/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.subobject;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.LabelParser;
import org.opendaylight.protocol.pcep.spi.LabelSerializer;
import org.opendaylight.protocol.pcep.spi.LabelUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.LabelType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.label.type.GeneralizedLabelCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.label.type.GeneralizedLabelCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.label.type.generalized.label._case.GeneralizedLabel;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.label.type.generalized.label._case.GeneralizedLabelBuilder;

public class GeneralizedLabelParser
implements LabelParser,
LabelSerializer {
    public static final int CTYPE = 2;

    @Override
    public LabelType parseLabel(ByteBuf buffer) throws PCEPDeserializerException {
        Preconditions.checkArgument(buffer != null && buffer.isReadable(), "Array of bytes is mandatory. Can't be null or empty.");
        return new GeneralizedLabelCaseBuilder().setGeneralizedLabel(new GeneralizedLabelBuilder().setGeneralizedLabel(ByteArray.readAllBytes(buffer)).build()).build();
    }

    @Override
    public void serializeLabel(boolean unidirectional, boolean global, LabelType subobject, ByteBuf buffer) {
        Preconditions.checkArgument(subobject instanceof GeneralizedLabelCase, "Unknown Label Subobject instance. Passed {}. Needed GeneralizedLabelCase.", subobject.getClass());
        GeneralizedLabel gl = ((GeneralizedLabelCase)subobject).getGeneralizedLabel();
        Preconditions.checkArgument(gl != null, "GeneralizedLabel is mandatory.");
        ByteBuf body = Unpooled.wrappedBuffer(gl.getGeneralizedLabel());
        LabelUtil.formatLabel(2, unidirectional, global, body, buffer);
    }
}

