/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.subobject;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.RROSubobjectParser;
import org.opendaylight.protocol.pcep.spi.RROSubobjectSerializer;
import org.opendaylight.protocol.pcep.spi.RROSubobjectUtil;
import org.opendaylight.protocol.util.BitArray;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.protocol.util.Ipv6Util;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.reported.route.object.rro.Subobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.reported.route.object.rro.SubobjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.record.route.subobjects.subobject.type.IpPrefixCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.record.route.subobjects.subobject.type.IpPrefixCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.record.route.subobjects.subobject.type.ip.prefix._case.IpPrefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.record.route.subobjects.subobject.type.ip.prefix._case.IpPrefixBuilder;

public class RROIpv6PrefixSubobjectParser
implements RROSubobjectParser,
RROSubobjectSerializer {
    public static final int TYPE = 2;
    private static final int PREFIX_F_LENGTH = 1;
    private static final int FLAGS_SIZE = 8;
    private static final int PREFIX_F_OFFSET = 16;
    private static final int CONTENT_LENGTH = 18;
    private static final int LPA_F_OFFSET = 7;
    private static final int LPIU_F_OFFSET = 6;

    @Override
    public Subobject parseSubobject(ByteBuf buffer) throws PCEPDeserializerException {
        Preconditions.checkArgument(buffer != null && buffer.isReadable(), "Array of bytes is mandatory. Can't be null or empty.");
        SubobjectBuilder builder = new SubobjectBuilder();
        if (buffer.readableBytes() != 18) {
            throw new PCEPDeserializerException("Wrong length of array of bytes. Passed: " + buffer.readableBytes() + ";");
        }
        short length = buffer.getUnsignedByte(16);
        IpPrefixBuilder prefix = new IpPrefixBuilder().setIpPrefix(new org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix(Ipv6Util.prefixForBytes(ByteArray.readBytes(buffer, 16), length)));
        buffer.skipBytes(1);
        BitArray flags = BitArray.valueOf(buffer, 8);
        builder.setProtectionAvailable(flags.get(7));
        builder.setProtectionInUse(flags.get(6));
        builder.setSubobjectType(new IpPrefixCaseBuilder().setIpPrefix(prefix.build()).build());
        return builder.build();
    }

    @Override
    public void serializeSubobject(Subobject subobject, ByteBuf buffer) {
        Preconditions.checkArgument(subobject.getSubobjectType() instanceof IpPrefixCase, "Unknown subobject instance. Passed %s. Needed IpPrefixCase.", subobject.getSubobjectType().getClass());
        IpPrefix specObj = ((IpPrefixCase)subobject.getSubobjectType()).getIpPrefix();
        org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix prefix = specObj.getIpPrefix();
        BitArray flags = new BitArray(8);
        flags.set(7, subobject.isProtectionAvailable());
        flags.set(6, subobject.isProtectionInUse());
        ByteBuf body = Unpooled.buffer(18);
        Preconditions.checkArgument(prefix.getIpv6Prefix() != null, "Ipv6Prefix is mandatory.");
        ByteBufWriteUtil.writeIpv6Prefix(prefix.getIpv6Prefix(), body);
        flags.toByteBuf(body);
        RROSubobjectUtil.formatSubobject(2, body, buffer);
    }
}

