/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.subobject;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Objects;
import org.opendaylight.protocol.pcep.spi.LabelRegistry;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.RROSubobjectParser;
import org.opendaylight.protocol.pcep.spi.RROSubobjectSerializer;
import org.opendaylight.protocol.pcep.spi.RROSubobjectUtil;
import org.opendaylight.protocol.util.BitArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.reported.route.object.rro.Subobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.reported.route.object.rro.SubobjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.LabelType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.record.route.subobjects.subobject.type.LabelCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.record.route.subobjects.subobject.type.LabelCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.record.route.subobjects.subobject.type.label._case.Label;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.record.route.subobjects.subobject.type.label._case.LabelBuilder;

public class RROLabelSubobjectParser
implements RROSubobjectParser,
RROSubobjectSerializer {
    public static final int TYPE = 3;
    public static final int FLAGS_SIZE = 8;
    public static final int C_TYPE_F_LENGTH = 1;
    public static final int C_TYPE_F_OFFSET = 1;
    public static final int HEADER_LENGTH = 2;
    public static final int U_FLAG_OFFSET = 0;
    public static final int G_FLAG_OFFSET = 7;
    private final LabelRegistry registry;

    public RROLabelSubobjectParser(LabelRegistry labelReg) {
        this.registry = Objects.requireNonNull(labelReg);
    }

    @Override
    public Subobject parseSubobject(ByteBuf buffer) throws PCEPDeserializerException {
        Preconditions.checkArgument(buffer != null && buffer.isReadable(), "Array of bytes is mandatory. Can't be null or empty.");
        if (buffer.readableBytes() < 2) {
            throw new PCEPDeserializerException("Wrong length of array of bytes. Passed: " + buffer.readableBytes() + "; Expected: >" + 2 + ".");
        }
        BitArray reserved = BitArray.valueOf(buffer, 8);
        short cType = buffer.readUnsignedByte();
        LabelType labelType = this.registry.parseLabel(cType, buffer.slice());
        if (labelType == null) {
            throw new PCEPDeserializerException("Unknown C-TYPE for ero label subobject. Passed: " + cType);
        }
        LabelBuilder builder = new LabelBuilder();
        builder.setUniDirectional(reserved.get(0));
        builder.setGlobal(reserved.get(7));
        builder.setLabelType(labelType);
        return new SubobjectBuilder().setSubobjectType(new LabelCaseBuilder().setLabel(builder.build()).build()).build();
    }

    @Override
    public void serializeSubobject(Subobject subobject, ByteBuf buffer) {
        Objects.requireNonNull(subobject.getSubobjectType(), "Subobject type cannot be empty.");
        Label label = ((LabelCase)subobject.getSubobjectType()).getLabel();
        ByteBuf body = Unpooled.buffer();
        this.registry.serializeLabel(label.isUniDirectional(), label.isGlobal(), label.getLabelType(), body);
        RROSubobjectUtil.formatSubobject(3, body, buffer);
    }
}

