/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.subobject;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.parser.subobject.RROPathKey128SubobjectParser;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.RROSubobjectParser;
import org.opendaylight.protocol.pcep.spi.RROSubobjectSerializer;
import org.opendaylight.protocol.pcep.spi.RROSubobjectUtil;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.reported.route.object.rro.Subobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.reported.route.object.rro.SubobjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.PathKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.PceId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.record.route.subobjects.subobject.type.PathKeyCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.record.route.subobjects.subobject.type.PathKeyCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.record.route.subobjects.subobject.type.path.key._case.PathKeyBuilder;

public class RROPathKey32SubobjectParser
implements RROSubobjectParser,
RROSubobjectSerializer {
    public static final int TYPE = 64;
    private static final int PK_F_LENGTH = 2;
    private static final int PCE_ID_F_LENGTH = 4;
    private static final int PK_F_OFFSET = 0;
    private static final int PCE_ID_F_OFFSET = 2;
    private static final int CONTENT_LENGTH = 6;

    @Override
    public Subobject parseSubobject(ByteBuf buffer) throws PCEPDeserializerException {
        Preconditions.checkArgument(buffer != null && buffer.isReadable(), "Array of bytes is mandatory. Can't be null or empty.");
        if (buffer.readableBytes() != 6) {
            throw new PCEPDeserializerException("Wrong length of array of bytes. Passed: " + buffer.readableBytes() + "; Expected: >" + 6 + ".");
        }
        int pathKey = buffer.readUnsignedShort();
        byte[] pceId = ByteArray.readBytes(buffer, 4);
        SubobjectBuilder builder = new SubobjectBuilder();
        PathKeyBuilder pBuilder = new PathKeyBuilder();
        pBuilder.setPceId(new PceId(pceId));
        pBuilder.setPathKey(new PathKey(pathKey));
        builder.setSubobjectType(new PathKeyCaseBuilder().setPathKey(pBuilder.build()).build());
        return builder.build();
    }

    @Override
    public void serializeSubobject(Subobject subobject, ByteBuf buffer) {
        Preconditions.checkArgument(subobject.getSubobjectType() instanceof PathKeyCase, "Unknown subobject instance. Passed %s. Needed PathKey.", subobject.getSubobjectType().getClass());
        PathKeyCase pkcase = (PathKeyCase)subobject.getSubobjectType();
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.record.route.subobjects.subobject.type.path.key._case.PathKey pk = pkcase.getPathKey();
        ByteBuf body = Unpooled.buffer();
        Preconditions.checkArgument(pk.getPceId() != null, "PceId is mandatory.");
        byte[] pceId = pk.getPceId().getValue();
        if (pceId.length == 16) {
            RROPathKey128SubobjectParser.serializeSubobject(subobject, buffer);
        }
        Preconditions.checkArgument(pk.getPathKey() != null, "PathKey is mandatory.");
        ByteBufWriteUtil.writeUnsignedShort(pk.getPathKey().getValue(), body);
        Preconditions.checkArgument(pceId.length == 4, "PceId 32 Bit required.");
        body.writeBytes(pceId);
        RROSubobjectUtil.formatSubobject(64, body, buffer);
    }
}

