/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.tlv;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvParser;
import org.opendaylight.protocol.pcep.spi.TlvSerializer;
import org.opendaylight.protocol.pcep.spi.TlvUtil;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.order.tlv.Order;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.order.tlv.OrderBuilder;

public class OrderTlvParser
implements TlvParser,
TlvSerializer {
    public static final int TYPE = 5;

    @Override
    public Order parseTlv(ByteBuf buffer) throws PCEPDeserializerException {
        if (buffer == null) {
            return null;
        }
        return new OrderBuilder().setDelete(buffer.readUnsignedInt()).setSetup(buffer.readUnsignedInt()).build();
    }

    @Override
    public void serializeTlv(Tlv tlv, ByteBuf buffer) {
        Preconditions.checkArgument(tlv instanceof Order, "OrderTlv is mandatory.");
        Order otlv = (Order)tlv;
        ByteBuf body = Unpooled.buffer();
        ByteBufWriteUtil.writeUnsignedInt(otlv.getDelete(), body);
        ByteBufWriteUtil.writeUnsignedInt(otlv.getSetup(), body);
        TlvUtil.formatTlv(5, body, buffer);
    }
}

