/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.spi;

import com.google.common.base.Optional;
import com.google.common.primitives.UnsignedBytes;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.opendaylight.protocol.pcep.spi.MessageParser;
import org.opendaylight.protocol.pcep.spi.MessageSerializer;
import org.opendaylight.protocol.pcep.spi.ObjectHeaderImpl;
import org.opendaylight.protocol.pcep.spi.ObjectRegistry;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.protocol.pcep.spi.VendorInformationUtil;
import org.opendaylight.protocol.util.BitArray;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.iana.rev130816.EnterpriseNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev131007.PcerrBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcep.error.object.ErrorObjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.PcerrMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.ErrorsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.error.type.RequestCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.error.type.request._case.RequestBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcerr.message.pcerr.message.error.type.request._case.request.RpsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.objects.VendorInformationObject;

public abstract class AbstractMessageParser
implements MessageParser,
MessageSerializer {
    private static final int COMMON_OBJECT_HEADER_LENGTH = 4;
    private static final int OT_SF_LENGTH = 4;
    private static final int OT_SF_OFFSET = 0;
    private static final int PROCESSED = 6;
    private static final int IGNORED = 7;
    private final ObjectRegistry registry;

    protected AbstractMessageParser(ObjectRegistry registry) {
        this.registry = Objects.requireNonNull(registry);
    }

    protected void serializeObject(@Nullable Object object, ByteBuf buffer) {
        if (object == null) {
            return;
        }
        this.registry.serializeObject(object, buffer);
    }

    private List<Object> parseObjects(ByteBuf bytes) throws PCEPDeserializerException {
        ArrayList<Object> objs = new ArrayList<Object>();
        while (bytes.isReadable()) {
            if (bytes.readableBytes() < 4) {
                throw new PCEPDeserializerException("Too few bytes in passed array. Passed: " + bytes.readableBytes() + " Expected: >= " + 4 + ".");
            }
            short objClass = bytes.readUnsignedByte();
            byte flagsByte = bytes.readByte();
            BitArray flags = BitArray.valueOf(flagsByte);
            int objType = UnsignedBytes.toInt(ByteArray.copyBitsRange(flagsByte, 0, 4));
            int objLength = bytes.readUnsignedShort();
            if (bytes.readableBytes() < objLength - 4) {
                throw new PCEPDeserializerException("Too few bytes in passed array. Passed: " + bytes.readableBytes() + " Expected: >= " + objLength + ".");
            }
            ByteBuf bytesToPass = bytes.readSlice(objLength - 4);
            ObjectHeaderImpl header = new ObjectHeaderImpl(flags.get(6), flags.get(7));
            if (VendorInformationUtil.isVendorInformationObject(objClass, objType)) {
                EnterpriseNumber enterpriseNumber = new EnterpriseNumber(bytesToPass.readUnsignedInt());
                Optional<? extends Object> obj = this.registry.parseVendorInformationObject(enterpriseNumber, header, bytesToPass);
                if (!obj.isPresent()) continue;
                objs.add(obj.get());
                continue;
            }
            Object o = this.registry.parseObject(objClass, objType, header, bytesToPass);
            if (o == null) continue;
            objs.add(o);
        }
        return objs;
    }

    public static Message createErrorMsg(PCEPErrors e, Optional<Rp> rp) {
        PcerrMessageBuilder msgBuilder = new PcerrMessageBuilder();
        if (rp.isPresent()) {
            new RequestCaseBuilder().setRequest(new RequestBuilder().setRps(Collections.singletonList(new RpsBuilder().setRp(rp.get()).build())).build()).build();
        }
        return new PcerrBuilder().setPcerrMessage(msgBuilder.setErrors(Collections.singletonList(new ErrorsBuilder().setErrorObject(new ErrorObjectBuilder().setType(e.getErrorType()).setValue(e.getErrorValue()).build()).build())).build()).build();
    }

    protected abstract Message validate(List<Object> var1, List<Message> var2) throws PCEPDeserializerException;

    @Override
    public final Message parseMessage(ByteBuf buffer, List<Message> errors) throws PCEPDeserializerException {
        Objects.requireNonNull(buffer, "Buffer may not be null");
        List<Object> objs = this.parseObjects(buffer);
        return this.validate(objs, errors);
    }

    protected final void serializeVendorInformationObjects(List<VendorInformationObject> viObjects, ByteBuf buffer) {
        if (viObjects != null) {
            for (VendorInformationObject viObject : viObjects) {
                this.registry.serializeVendorInformationObject(viObject, buffer);
            }
        }
    }

    protected static List<VendorInformationObject> addVendorInformationObjects(List<Object> objects) {
        ArrayList<VendorInformationObject> vendorInfo = new ArrayList<VendorInformationObject>();
        while (!objects.isEmpty() && objects.get(0) instanceof VendorInformationObject) {
            VendorInformationObject viObject = (VendorInformationObject)objects.get(0);
            vendorInfo.add(viObject);
            objects.remove(0);
        }
        return vendorInfo;
    }
}

