/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.spi;

import com.google.common.collect.Maps;
import java.util.Map;
import org.opendaylight.protocol.pcep.spi.PCEPErrorIdentifier;

public enum PCEPErrors {
    NON_OR_INVALID_OPEN_MSG(1, 1),
    NO_OPEN_BEFORE_EXP_OPENWAIT(1, 2),
    NON_ACC_NON_NEG_SESSION_CHAR(1, 3),
    NON_ACC_NEG_SESSION_CHAR(1, 4),
    SECOND_OPEN_MSG(1, 5),
    PCERR_NON_ACC_SESSION_CHAR(1, 6),
    NO_MSG_BEFORE_EXP_KEEPWAIT(1, 7),
    CAPABILITY_NOT_SUPPORTED(2, 0),
    PCEP_VERSION_NOT_SUPPORTED(1, 8),
    UNRECOGNIZED_OBJ_CLASS(3, 1),
    UNRECOGNIZED_OBJ_TYPE(3, 2),
    NOT_SUPPORTED_OBJ_CLASS(4, 1),
    NOT_SUPPORTED_OBJ_TYPE(4, 2),
    C_BIT_SET(5, 1),
    O_BIT_SET(5, 2),
    OF_NOT_ALLOWED(5, 3),
    OF_BIT_SET(5, 4),
    GCO_NOT_ALLOWED(5, 5),
    P2MP_COMPUTATION_NOT_ALLOWED(5, 7),
    RP_MISSING(6, 1),
    RRO_MISSING(6, 2),
    END_POINTS_MISSING(6, 3),
    LSP_CLEANUP_TLV_MISSING(6, 13),
    SYMBOLIC_PATH_NAME_MISSING(6, 14),
    SYNC_PATH_COMP_REQ_MISSING(7, 0),
    UNKNOWN_REQ_REF(8, 0),
    ATTEMPT_2ND_SESSION(9, 0),
    LSP_MISSING(6, 8),
    ERO_MISSING(6, 9),
    SRP_MISSING(6, 10),
    LSP_IDENTIFIERS_TLV_MISSING(6, 11),
    P_FLAG_NOT_SET(10, 1),
    INSUFFICIENT_MEMORY(15, 1),
    GCO_NOT_SUPPORTED(15, 2),
    UNSUPPORTED_CT(12, 1),
    INVALID_CT(12, 2),
    CT_AND_SETUP_PRIORITY_DO_NOT_FORM_TE_CLASS(12, 3),
    CANNOT_SATISFY_P2MP_REQUEST_DUE_TO_INSUFFISIENT_MEMMORY(16, 1),
    NOT_CAPPABLE_P2MP_COMPUTATION(16, 2),
    P2MP_NOT_CAPPABLE_SATISFY_REQ_DUE_LT2(17, 1),
    P2MP_NOT_CAPPABLE_SATISFY_REQ_DUE_LT3(17, 2),
    P2MP_NOT_CAPPABLE_SATISFY_REQ_DUE_LT4(17, 3),
    P2MP_NOT_CAPPABLE_SATISFY_REQ_DUE_INCONSISTENT_EP(17, 4),
    P2MP_FRAGMENTATION_FAILRUE(18, 1),
    UPDATE_REQ_FOR_NON_LSP(19, 1),
    UPDATE_REQ_FOR_NO_STATEFUL(19, 2),
    UNKNOWN_PLSP_ID(19, 3),
    RESOURCE_LIMIT_EXCEEDED(19, 4),
    LSP_LIMIT_EXCEEDED(19, 6),
    DELEGATION_NON_REVOKABLE(19, 7),
    NON_ZERO_PLSPID(19, 8),
    CANNOT_PROCESS_STATE_REPORT(20, 1),
    LSP_DB_VERSION_MISMATCH(20, 2),
    DB_VERSION_TLV_MISSING_WHEN_SYNC_ALLOWED(20, 3),
    CANNOT_COMPLETE_STATE_SYNC(20, 5),
    USED_SYMBOLIC_PATH_NAME(23, 1),
    LSP_UNACC_INST_PARAMS(24, 1),
    LSP_INTERNAL_ERROR(24, 2),
    LSP_RSVP_ERROR(24, 3),
    BAD_LABEL_VALUE(10, 2),
    UNSUPPORTED_NUMBER_OF_SR_ERO_SUBOBJECTS(10, 3),
    BAD_LABEL_FORMAT(10, 4),
    NON_IDENTICAL_ERO_SUBOBJECTS(10, 5),
    SID_AND_NAI_ABSENT_IN_ERO(10, 6),
    SID_AND_NAI_ABSENT_IN_RRO(10, 7),
    SID_NON_IDENTICAL_RRO_SUBOBJECTS(10, 8),
    UNSUPPORTED_PST(21, 1),
    MISMATCHED_PST(21, 2),
    MONITORING_OBJECT_MISSING(6, 4),
    STARTTLS_RCVD_INCORRECTLY(30, 1),
    NON_STARTTLS_MSG_RCVD(30, 2),
    NOT_POSSIBLE_WITHOUT_TLS(30, 3),
    POSSIBLE_WITHOUT_TLS(30, 4),
    STARTTLS_TIMER_EXP(30, 5),
    LSP_NOT_PCE_INITIATED(19, 9),
    LSP_DB_VERSION_MISSING(6, 12),
    UNEXPECTED_SYNCHRONIZATION_ATTEMPT(20, 4),
    NO_SUFFICIENT_LSP_CHANGE(20, 6),
    INVALID_LSP_DB_VERSION(20, 7);

    private PCEPErrorIdentifier errorId;
    private static final Map<PCEPErrorIdentifier, PCEPErrors> VALUE_MAP;

    public static PCEPErrors forValue(short errorType, short errorValue) {
        return VALUE_MAP.get(new PCEPErrorIdentifier(errorType, errorValue));
    }

    private PCEPErrors(int type, int value) {
        this.errorId = new PCEPErrorIdentifier((short)type, (short)value);
    }

    private PCEPErrorIdentifier getErrorIdentifier() {
        return this.errorId;
    }

    public short getErrorType() {
        return this.errorId.getType();
    }

    public short getErrorValue() {
        return this.errorId.getValue();
    }

    static {
        VALUE_MAP = Maps.newHashMap();
        for (PCEPErrors enumItem : PCEPErrors.values()) {
            VALUE_MAP.put(enumItem.getErrorIdentifier(), enumItem);
        }
    }
}

