/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.spi.pojo;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.GuardedBy;
import org.opendaylight.protocol.pcep.spi.PCEPExtensionProviderActivator;
import org.opendaylight.protocol.pcep.spi.PCEPExtensionProviderContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPCEPExtensionProviderActivator
implements AutoCloseable,
PCEPExtensionProviderActivator {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractPCEPExtensionProviderActivator.class);
    @GuardedBy(value="this")
    private List<AutoCloseable> registrations;

    @GuardedBy(value="this")
    protected abstract List<AutoCloseable> startImpl(PCEPExtensionProviderContext var1);

    @Override
    public final synchronized void start(PCEPExtensionProviderContext context) {
        Preconditions.checkState(this.registrations == null);
        this.registrations = Objects.requireNonNull(this.startImpl(context));
    }

    @Override
    public final synchronized void stop() {
        if (this.registrations == null) {
            return;
        }
        for (AutoCloseable r : this.registrations) {
            try {
                r.close();
            }
            catch (Exception e) {
                LOG.warn("Failed to close registration", e);
            }
        }
        this.registrations = null;
    }

    @Override
    public final void close() {
        this.stop();
    }
}

