/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.spi.pojo;

import com.google.common.base.Optional;
import com.google.common.primitives.Ints;
import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.concepts.HandlerRegistry;
import org.opendaylight.protocol.pcep.spi.ObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectSerializer;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.protocol.pcep.spi.UnknownObject;
import org.opendaylight.protocol.pcep.spi.VendorInformationObjectRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.iana.rev130816.EnterpriseNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.EnterpriseSpecificInformation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.objects.VendorInformationObject;
import org.opendaylight.yangtools.yang.binding.DataContainer;

public class SimpleVendorInformationObjectRegistry
implements VendorInformationObjectRegistry {
    private final HandlerRegistry<DataContainer, ObjectParser, ObjectSerializer> handlers = new HandlerRegistry();

    public AutoCloseable registerVendorInformationObjectParser(EnterpriseNumber enterpriseNumber, ObjectParser parser) {
        return this.handlers.registerParser(Ints.checkedCast(enterpriseNumber.getValue()), parser);
    }

    public AutoCloseable registerVendorInformationObjectSerializer(Class<? extends EnterpriseSpecificInformation> esInformationClass, ObjectSerializer serializer) {
        return this.handlers.registerSerializer(esInformationClass, serializer);
    }

    @Override
    public Optional<? extends Object> parseVendorInformationObject(EnterpriseNumber enterpriseNumber, ObjectHeader header, ByteBuf buffer) throws PCEPDeserializerException {
        ObjectParser parser = this.handlers.getParser(Ints.checkedCast(enterpriseNumber.getValue()));
        if (parser == null) {
            if (!header.isProcessingRule().booleanValue()) {
                return Optional.absent();
            }
            return Optional.of(new UnknownObject(PCEPErrors.UNRECOGNIZED_OBJ_CLASS));
        }
        return Optional.of(parser.parseObject(header, buffer));
    }

    @Override
    public void serializeVendorInformationObject(VendorInformationObject viObject, ByteBuf buffer) {
        ObjectSerializer serializer = this.handlers.getSerializer(viObject.getEnterpriseSpecificInformation().getImplementedInterface());
        if (serializer == null) {
            return;
        }
        serializer.serializeObject(viObject, buffer);
    }
}

