/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.sync.optimizations;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.math.BigInteger;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvParser;
import org.opendaylight.protocol.pcep.spi.TlvSerializer;
import org.opendaylight.protocol.pcep.spi.TlvUtil;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sync.optimizations.rev171025.lsp.db.version.tlv.LspDbVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.sync.optimizations.rev171025.lsp.db.version.tlv.LspDbVersionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Tlv;

public class LspDbVersionTlvParser
implements TlvParser,
TlvSerializer {
    public static final int TYPE = 23;

    @Override
    public void serializeTlv(Tlv tlv, ByteBuf buffer) {
        Preconditions.checkArgument(tlv instanceof LspDbVersion, "Tlv object is not instance of LspDbVersion.");
        ByteBuf body = Unpooled.buffer();
        ByteBufWriteUtil.writeUnsignedLong(((LspDbVersion)tlv).getLspDbVersionValue(), body);
        TlvUtil.formatTlv(23, body, buffer);
    }

    @Override
    public Tlv parseTlv(ByteBuf buffer) throws PCEPDeserializerException {
        if (buffer == null) {
            return null;
        }
        return new LspDbVersionBuilder().setLspDbVersionValue(new BigInteger(ByteArray.readAllBytes(buffer))).build();
    }
}

