/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.testtool;

import io.netty.channel.nio.NioEventLoopGroup;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import org.opendaylight.protocol.pcep.PCEPCapability;
import org.opendaylight.protocol.pcep.PCEPSessionProposalFactory;
import org.opendaylight.protocol.pcep.ietf.stateful07.PCEPStatefulCapability;
import org.opendaylight.protocol.pcep.ietf.stateful07.StatefulActivator;
import org.opendaylight.protocol.pcep.impl.BasePCEPSessionProposalFactory;
import org.opendaylight.protocol.pcep.impl.DefaultPCEPSessionNegotiatorFactory;
import org.opendaylight.protocol.pcep.impl.PCEPDispatcherImpl;
import org.opendaylight.protocol.pcep.spi.pojo.ServiceLoaderPCEPExtensionProviderContext;
import org.opendaylight.protocol.pcep.testtool.TestToolPCEPDispatcherDependencies;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Main {
    private static final Logger LOG = LoggerFactory.getLogger(Main.class);
    private static final String USAGE = "DESCRIPTION:\n\tCreates a server with given parameters. As long as it runs, it accepts connections from PCCs.\nUSAGE:\n\t-a, --address\n\t\tthe ip address to which is this server bound.\n\t\tFormat: x.x.x.x:y where y is port number.\n\n\t-d, --deadtimer\n\t\tin seconds, value of the desired deadtimer\n\t\tAccording to RFC5440, recommended value for deadtimer is 4 times the value\n\t\tof KeepAlive timer. If it's not, a warning is printed.\n\t\tIf not set, it's value will be derived from KeepAlive timer value.\n\n\t-ka, --keepalive\n\t\tin seconds, value of the desired KeepAlive timer.\n\t\tIf not present, KeepAlive timer will be set to recommended value (30s).\n\n\t--stateful\n\t\tpassive stateful\n\n\t--active\n\t\tactive stateful (implies --stateful)\n\n\t--instant\n\t\tinstantiated stateful, <seconds> cleanup timeout (default value, if not included = 0) (implies --stateful)\n\n\t-arm, --autoResponseMessages <path to file>\n\t\t <path to file> with groovy script which implements MessageGeneratorService.\n\t\t Messages are used as auto response for every message received. Purely for testing puposes! \n\n\t-psm, --periodicallySendMessages <path to file> <period>\n\t\t <path to file> with groovy script which implements MessageGeneratorService followed by <period> in seconds.\n\t\t Messages which are sent periodically. Purely for testing puposes! \n\n\t-snm, --sendNowMessage <path to file>\n\t\t <path to file> with groovy script which implements MessageGeneratorService.\n\t\t Messages are sent in defined states defined by programmer. Purely for testing puposes! \n\n\t--help\n\t\tdisplay this help and exits\n\nWith no parameters, this help is printed.";
    private static final int KA_TO_DEADTIMER_RATIO = 4;
    private static final int KA_DEFAULT = 30;
    private static final int MAX_UNKNOWN_MESSAGES = 5;

    private Main() {
    }

    public static void main(String[] args) throws UnknownHostException, InterruptedException, ExecutionException {
        if (args.length == 0 || args.length == 1 && args[0].equalsIgnoreCase("--help")) {
            LOG.info(USAGE);
            return;
        }
        InetSocketAddress address = null;
        int keepAliveValue = 30;
        int deadTimerValue = 0;
        boolean stateful = false;
        boolean active = false;
        boolean instant = false;
        for (int pos = 0; pos < args.length; ++pos) {
            if (args[pos].equalsIgnoreCase("-a") || args[pos].equalsIgnoreCase("--address")) {
                String[] ip = args[pos + 1].split(":");
                address = new InetSocketAddress(InetAddress.getByName(ip[0]), Integer.parseInt(ip[1]));
                ++pos;
                continue;
            }
            if (args[pos].equalsIgnoreCase("-d") || args[pos].equalsIgnoreCase("--deadtimer")) {
                deadTimerValue = Integer.parseInt(args[pos + 1]);
                ++pos;
                continue;
            }
            if (args[pos].equalsIgnoreCase("-ka") || args[pos].equalsIgnoreCase("--keepalive")) {
                keepAliveValue = Integer.parseInt(args[pos + 1]);
                ++pos;
                continue;
            }
            if (args[pos].equalsIgnoreCase("--stateful")) {
                stateful = true;
                continue;
            }
            if (args[pos].equalsIgnoreCase("--active")) {
                stateful = true;
                active = true;
                continue;
            }
            if (args[pos].equalsIgnoreCase("--instant")) {
                stateful = true;
                instant = true;
                continue;
            }
            LOG.warn("WARNING: Unrecognized argument: {}", (Object)args[pos]);
        }
        if (deadTimerValue != 0 && deadTimerValue != keepAliveValue * 4) {
            LOG.warn("WARNING: The value of DeadTimer should be 4 times the value of KeepAlive.");
        }
        if (deadTimerValue == 0) {
            deadTimerValue = keepAliveValue * 4;
        }
        ArrayList<PCEPCapability> caps = new ArrayList<PCEPCapability>();
        caps.add(new PCEPStatefulCapability(stateful, active, instant, false, false, false, false));
        BasePCEPSessionProposalFactory spf = new BasePCEPSessionProposalFactory(deadTimerValue, keepAliveValue, caps);
        try (StatefulActivator activator07 = new StatefulActivator();){
            activator07.start(ServiceLoaderPCEPExtensionProviderContext.getSingletonInstance());
            PCEPDispatcherImpl dispatcher = new PCEPDispatcherImpl(ServiceLoaderPCEPExtensionProviderContext.getSingletonInstance().getMessageHandlerRegistry(), new DefaultPCEPSessionNegotiatorFactory((PCEPSessionProposalFactory)spf, 5), new NioEventLoopGroup(), new NioEventLoopGroup());
            dispatcher.createServer(new TestToolPCEPDispatcherDependencies(address)).get();
        }
    }
}

