/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.util;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import org.opendaylight.protocol.util.ArgumentsInput;
import org.slf4j.LoggerFactory;

public final class LoggerUtil {
    private LoggerUtil() {
        throw new UnsupportedOperationException();
    }

    public static void initiateLogger(ArgumentsInput arguments) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        ConsoleAppender<ILoggingEvent> consoleAppender = LoggerUtil.createConsoleAppender(loggerContext);
        LoggerUtil.setLogLevel(consoleAppender, Level.OFF, "ROOT");
        LoggerUtil.setLogLevel(consoleAppender, arguments.getLogLevel(), "org.opendaylight.protocol");
    }

    private static ConsoleAppender<ILoggingEvent> createConsoleAppender(LoggerContext loggerContext) {
        PatternLayoutEncoder ple = new PatternLayoutEncoder();
        ple.setPattern("%d{HH:mm:ss.SSS} [%thread] %-5level %logger{10} - %msg%n");
        ple.setContext(loggerContext);
        ple.start();
        ConsoleAppender<ILoggingEvent> consoleAppender = new ConsoleAppender<ILoggingEvent>();
        consoleAppender.setContext(loggerContext);
        consoleAppender.setEncoder(ple);
        consoleAppender.setName("STDOUT");
        consoleAppender.start();
        return consoleAppender;
    }

    private static void setLogLevel(ConsoleAppender<ILoggingEvent> consoleAppender, Level level, String clazz) {
        Logger protocolLogger = (Logger)LoggerFactory.getLogger(clazz);
        protocolLogger.addAppender((Appender<ILoggingEvent>)consoleAppender);
        protocolLogger.setLevel(level);
        protocolLogger.setAdditive(false);
    }
}

