/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715;

import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

public class AsNumber
implements Serializable {
    private static final long serialVersionUID = 3880971349126258475L;
    private final Long _value;

    private static void check_valueRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", (Object)value);
    }

    @ConstructorProperties(value={"value"})
    public AsNumber(Long _value) {
        if (_value != null) {
            AsNumber.check_valueRange(_value);
        }
        Objects.requireNonNull(_value, "Supplied value may not be null");
        this._value = _value;
    }

    public AsNumber(AsNumber source) {
        this._value = source._value;
    }

    public static AsNumber getDefaultInstance(String defaultValue) {
        return new AsNumber(Long.valueOf(defaultValue));
    }

    public Long getValue() {
        return this._value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AsNumber other = (AsNumber)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(AsNumber.class);
        CodeHelpers.appendValue(helper, "_value", this._value);
        return helper.toString();
    }
}

