/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.binding.Enumeration;

public enum IpVersion implements Enumeration
{
    Unknown(0, "unknown"),
    Ipv4(1, "ipv4"),
    Ipv6(2, "ipv6");

    private static final Map<String, IpVersion> NAME_MAP;
    private static final Map<Integer, IpVersion> VALUE_MAP;
    private final String name;
    private final int value;

    private IpVersion(int value, String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getIntValue() {
        return this.value;
    }

    public static Optional<IpVersion> forName(String name) {
        return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
    }

    public static IpVersion forValue(int intValue) {
        return VALUE_MAP.get(intValue);
    }

    static {
        ImmutableMap.Builder<String, IpVersion> nb = ImmutableMap.builder();
        ImmutableMap.Builder<Integer, IpVersion> vb = ImmutableMap.builder();
        for (IpVersion enumItem : IpVersion.values()) {
            vb.put(enumItem.value, enumItem);
            nb.put(enumItem.name, enumItem);
        }
        NAME_MAP = nb.build();
        VALUE_MAP = vb.build();
    }
}

