/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715;

import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

public class PortNumber
implements Serializable {
    private static final long serialVersionUID = -5341082755708920855L;
    private final Integer _value;

    private static void check_valueRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", (Object)value);
    }

    @ConstructorProperties(value={"value"})
    public PortNumber(Integer _value) {
        if (_value != null) {
            PortNumber.check_valueRange(_value);
        }
        Objects.requireNonNull(_value, "Supplied value may not be null");
        this._value = _value;
    }

    public PortNumber(PortNumber source) {
        this._value = source._value;
    }

    public static PortNumber getDefaultInstance(String defaultValue) {
        return new PortNumber(Integer.valueOf(defaultValue));
    }

    public Integer getValue() {
        return this._value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PortNumber other = (PortNumber)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(PortNumber.class);
        CodeHelpers.appendValue(helper, "_value", this._value);
        return helper.toString();
    }
}

