/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

public class HexString
implements Serializable {
    private static final long serialVersionUID = 9131618089557940291L;
    public static final List<String> PATTERN_CONSTANTS = ImmutableList.of("^(?:([0-9a-fA-F]{2}(:[0-9a-fA-F]{2})*)?)$");
    private static final Pattern patterns = Pattern.compile(PATTERN_CONSTANTS.get(0));
    private static final String regexes = "([0-9a-fA-F]{2}(:[0-9a-fA-F]{2})*)?";
    private final String _value;

    private static void check_valueLength(String value) {
    }

    @ConstructorProperties(value={"value"})
    public HexString(String _value) {
        if (_value != null) {
            HexString.check_valueLength(_value);
        }
        Objects.requireNonNull(_value, "Supplied value may not be null");
        CodeHelpers.checkPattern(_value, patterns, regexes);
        this._value = _value;
    }

    public HexString(HexString source) {
        this._value = source._value;
    }

    public static HexString getDefaultInstance(String defaultValue) {
        return new HexString(defaultValue);
    }

    public String getValue() {
        return this._value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HexString other = (HexString)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(HexString.class);
        CodeHelpers.appendValue(helper, "_value", this._value);
        return helper.toString();
    }
}

