/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.yang.types.rev130715;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

public class YangIdentifier
implements Serializable {
    private static final long serialVersionUID = 7734916821492871556L;
    public static final List<String> PATTERN_CONSTANTS = ImmutableList.of("^(?:.|..|[^xX].*|.[^mM].*|..[^lL].*)$", "^(?:[a-zA-Z_][a-zA-Z0-9\\-_.]*)$");
    private static final Pattern[] patterns = CodeHelpers.compilePatterns(PATTERN_CONSTANTS);
    private static final String[] regexes = new String[]{".|..|[^xX].*|.[^mM].*|..[^lL].*", "[a-zA-Z_][a-zA-Z0-9\\-_.]*"};
    private final String _value;

    private static void check_valueLength(String value) {
        int length = value.length();
        if (length >= 1) {
            return;
        }
        CodeHelpers.throwInvalidLength("[[1..2147483647]]", value);
    }

    @ConstructorProperties(value={"value"})
    public YangIdentifier(String _value) {
        if (_value != null) {
            YangIdentifier.check_valueLength(_value);
        }
        Objects.requireNonNull(_value, "Supplied value may not be null");
        CodeHelpers.checkPattern(_value, patterns, regexes);
        this._value = _value;
    }

    public YangIdentifier(YangIdentifier source) {
        this._value = source._value;
    }

    public static YangIdentifier getDefaultInstance(String defaultValue) {
        return new YangIdentifier(defaultValue);
    }

    public String getValue() {
        return this._value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        YangIdentifier other = (YangIdentifier)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(YangIdentifier.class);
        CodeHelpers.appendValue(helper, "_value", this._value);
        return helper.toString();
    }
}

