/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.PathType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.StoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.app.config.rev160707.pcep.dispatcher.config.Tls;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TlsBuilder
implements Builder<Tls> {
    private String _certificatePassword;
    private String _keystore;
    private String _keystorePassword;
    private PathType _keystorePathType;
    private StoreType _keystoreType;
    private String _truststore;
    private String _truststorePassword;
    private PathType _truststorePathType;
    private StoreType _truststoreType;
    Map<Class<? extends Augmentation<Tls>>, Augmentation<Tls>> augmentation = Collections.emptyMap();

    public TlsBuilder() {
    }

    public TlsBuilder(Tls base) {
        AugmentationHolder casted;
        this._certificatePassword = base.getCertificatePassword();
        this._keystore = base.getKeystore();
        this._keystorePassword = base.getKeystorePassword();
        this._keystorePathType = base.getKeystorePathType();
        this._keystoreType = base.getKeystoreType();
        this._truststore = base.getTruststore();
        this._truststorePassword = base.getTruststorePassword();
        this._truststorePathType = base.getTruststorePathType();
        this._truststoreType = base.getTruststoreType();
        if (base instanceof TlsImpl) {
            TlsImpl impl = (TlsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Tls>>, Augmentation<Tls>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public String getCertificatePassword() {
        return this._certificatePassword;
    }

    public String getKeystore() {
        return this._keystore;
    }

    public String getKeystorePassword() {
        return this._keystorePassword;
    }

    public PathType getKeystorePathType() {
        return this._keystorePathType;
    }

    public StoreType getKeystoreType() {
        return this._keystoreType;
    }

    public String getTruststore() {
        return this._truststore;
    }

    public String getTruststorePassword() {
        return this._truststorePassword;
    }

    public PathType getTruststorePathType() {
        return this._truststorePathType;
    }

    public StoreType getTruststoreType() {
        return this._truststoreType;
    }

    public <E extends Augmentation<Tls>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public TlsBuilder setCertificatePassword(String value) {
        this._certificatePassword = value;
        return this;
    }

    public TlsBuilder setKeystore(String value) {
        this._keystore = value;
        return this;
    }

    public TlsBuilder setKeystorePassword(String value) {
        this._keystorePassword = value;
        return this;
    }

    public TlsBuilder setKeystorePathType(PathType value) {
        this._keystorePathType = value;
        return this;
    }

    public TlsBuilder setKeystoreType(StoreType value) {
        this._keystoreType = value;
        return this;
    }

    public TlsBuilder setTruststore(String value) {
        this._truststore = value;
        return this;
    }

    public TlsBuilder setTruststorePassword(String value) {
        this._truststorePassword = value;
        return this;
    }

    public TlsBuilder setTruststorePathType(PathType value) {
        this._truststorePathType = value;
        return this;
    }

    public TlsBuilder setTruststoreType(StoreType value) {
        this._truststoreType = value;
        return this;
    }

    public TlsBuilder addAugmentation(Class<? extends Augmentation<Tls>> augmentationType, Augmentation<Tls> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Tls>>, Augmentation<Tls>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public TlsBuilder removeAugmentation(Class<? extends Augmentation<Tls>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Tls build() {
        return new TlsImpl(this);
    }

    private static final class TlsImpl
    implements Tls {
        private final String _certificatePassword;
        private final String _keystore;
        private final String _keystorePassword;
        private final PathType _keystorePathType;
        private final StoreType _keystoreType;
        private final String _truststore;
        private final String _truststorePassword;
        private final PathType _truststorePathType;
        private final StoreType _truststoreType;
        private Map<Class<? extends Augmentation<Tls>>, Augmentation<Tls>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        private TlsImpl(TlsBuilder base) {
            this._certificatePassword = base.getCertificatePassword();
            this._keystore = base.getKeystore();
            this._keystorePassword = base.getKeystorePassword();
            this._keystorePathType = base.getKeystorePathType();
            this._keystoreType = base.getKeystoreType();
            this._truststore = base.getTruststore();
            this._truststorePassword = base.getTruststorePassword();
            this._truststorePathType = base.getTruststorePathType();
            this._truststoreType = base.getTruststoreType();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Tls> getImplementedInterface() {
            return Tls.class;
        }

        @Override
        public String getCertificatePassword() {
            return this._certificatePassword;
        }

        @Override
        public String getKeystore() {
            return this._keystore;
        }

        @Override
        public String getKeystorePassword() {
            return this._keystorePassword;
        }

        @Override
        public PathType getKeystorePathType() {
            return this._keystorePathType;
        }

        @Override
        public StoreType getKeystoreType() {
            return this._keystoreType;
        }

        @Override
        public String getTruststore() {
            return this._truststore;
        }

        @Override
        public String getTruststorePassword() {
            return this._truststorePassword;
        }

        @Override
        public PathType getTruststorePathType() {
            return this._truststorePathType;
        }

        @Override
        public StoreType getTruststoreType() {
            return this._truststoreType;
        }

        @Override
        public <E extends Augmentation<Tls>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._certificatePassword);
            result = 31 * result + Objects.hashCode(this._keystore);
            result = 31 * result + Objects.hashCode(this._keystorePassword);
            result = 31 * result + Objects.hashCode(this._keystorePathType);
            result = 31 * result + Objects.hashCode(this._keystoreType);
            result = 31 * result + Objects.hashCode(this._truststore);
            result = 31 * result + Objects.hashCode(this._truststorePassword);
            result = 31 * result + Objects.hashCode(this._truststorePathType);
            result = 31 * result + Objects.hashCode(this._truststoreType);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Tls.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Tls other = (Tls)obj;
            if (!Objects.equals(this._certificatePassword, other.getCertificatePassword())) {
                return false;
            }
            if (!Objects.equals(this._keystore, other.getKeystore())) {
                return false;
            }
            if (!Objects.equals(this._keystorePassword, other.getKeystorePassword())) {
                return false;
            }
            if (!Objects.equals(this._keystorePathType, other.getKeystorePathType())) {
                return false;
            }
            if (!Objects.equals(this._keystoreType, other.getKeystoreType())) {
                return false;
            }
            if (!Objects.equals(this._truststore, other.getTruststore())) {
                return false;
            }
            if (!Objects.equals(this._truststorePassword, other.getTruststorePassword())) {
                return false;
            }
            if (!Objects.equals(this._truststorePathType, other.getTruststorePathType())) {
                return false;
            }
            if (!Objects.equals(this._truststoreType, other.getTruststoreType())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TlsImpl otherImpl = (TlsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Tls>>, Augmentation<Tls>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Tls");
            CodeHelpers.appendValue(helper, "_certificatePassword", this._certificatePassword);
            CodeHelpers.appendValue(helper, "_keystore", this._keystore);
            CodeHelpers.appendValue(helper, "_keystorePassword", this._keystorePassword);
            CodeHelpers.appendValue(helper, "_keystorePathType", this._keystorePathType);
            CodeHelpers.appendValue(helper, "_keystoreType", this._keystoreType);
            CodeHelpers.appendValue(helper, "_truststore", this._truststore);
            CodeHelpers.appendValue(helper, "_truststorePassword", this._truststorePassword);
            CodeHelpers.appendValue(helper, "_truststorePathType", this._truststorePathType);
            CodeHelpers.appendValue(helper, "_truststoreType", this._truststoreType);
            CodeHelpers.appendValue(helper, "augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

