/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.ietf.stateful07.app.config.rev160707;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.ietf.stateful07.app.config.rev160707.PcepIetfStateful07Config;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.ietf.stateful07.app.config.rev160707.StatefulCapabilities;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PcepIetfStateful07ConfigBuilder
implements Builder<PcepIetfStateful07Config> {
    private Boolean _active;
    private Boolean _deltaLspSyncCapability;
    private Boolean _includeDbVersion;
    private Boolean _initiated;
    private Boolean _stateful;
    private Boolean _triggeredInitialSync;
    private Boolean _triggeredResync;
    Map<Class<? extends Augmentation<PcepIetfStateful07Config>>, Augmentation<PcepIetfStateful07Config>> augmentation = Collections.emptyMap();

    public PcepIetfStateful07ConfigBuilder() {
    }

    public PcepIetfStateful07ConfigBuilder(StatefulCapabilities arg) {
        this._initiated = arg.isInitiated();
        this._stateful = arg.isStateful();
        this._active = arg.isActive();
        this._triggeredInitialSync = arg.isTriggeredInitialSync();
        this._deltaLspSyncCapability = arg.isDeltaLspSyncCapability();
        this._triggeredResync = arg.isTriggeredResync();
        this._includeDbVersion = arg.isIncludeDbVersion();
    }

    public PcepIetfStateful07ConfigBuilder(PcepIetfStateful07Config base) {
        AugmentationHolder casted;
        this._active = base.isActive();
        this._deltaLspSyncCapability = base.isDeltaLspSyncCapability();
        this._includeDbVersion = base.isIncludeDbVersion();
        this._initiated = base.isInitiated();
        this._stateful = base.isStateful();
        this._triggeredInitialSync = base.isTriggeredInitialSync();
        this._triggeredResync = base.isTriggeredResync();
        if (base instanceof PcepIetfStateful07ConfigImpl) {
            PcepIetfStateful07ConfigImpl impl = (PcepIetfStateful07ConfigImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PcepIetfStateful07Config>>, Augmentation<PcepIetfStateful07Config>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof StatefulCapabilities) {
            this._initiated = ((StatefulCapabilities)arg).isInitiated();
            this._stateful = ((StatefulCapabilities)arg).isStateful();
            this._active = ((StatefulCapabilities)arg).isActive();
            this._triggeredInitialSync = ((StatefulCapabilities)arg).isTriggeredInitialSync();
            this._deltaLspSyncCapability = ((StatefulCapabilities)arg).isDeltaLspSyncCapability();
            this._triggeredResync = ((StatefulCapabilities)arg).isTriggeredResync();
            this._includeDbVersion = ((StatefulCapabilities)arg).isIncludeDbVersion();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.ietf.stateful07.app.config.rev160707.StatefulCapabilities]");
    }

    public Boolean isActive() {
        return this._active;
    }

    public Boolean isDeltaLspSyncCapability() {
        return this._deltaLspSyncCapability;
    }

    public Boolean isIncludeDbVersion() {
        return this._includeDbVersion;
    }

    public Boolean isInitiated() {
        return this._initiated;
    }

    public Boolean isStateful() {
        return this._stateful;
    }

    public Boolean isTriggeredInitialSync() {
        return this._triggeredInitialSync;
    }

    public Boolean isTriggeredResync() {
        return this._triggeredResync;
    }

    public <E extends Augmentation<PcepIetfStateful07Config>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public PcepIetfStateful07ConfigBuilder setActive(Boolean value) {
        this._active = value;
        return this;
    }

    public PcepIetfStateful07ConfigBuilder setDeltaLspSyncCapability(Boolean value) {
        this._deltaLspSyncCapability = value;
        return this;
    }

    public PcepIetfStateful07ConfigBuilder setIncludeDbVersion(Boolean value) {
        this._includeDbVersion = value;
        return this;
    }

    public PcepIetfStateful07ConfigBuilder setInitiated(Boolean value) {
        this._initiated = value;
        return this;
    }

    public PcepIetfStateful07ConfigBuilder setStateful(Boolean value) {
        this._stateful = value;
        return this;
    }

    public PcepIetfStateful07ConfigBuilder setTriggeredInitialSync(Boolean value) {
        this._triggeredInitialSync = value;
        return this;
    }

    public PcepIetfStateful07ConfigBuilder setTriggeredResync(Boolean value) {
        this._triggeredResync = value;
        return this;
    }

    public PcepIetfStateful07ConfigBuilder addAugmentation(Class<? extends Augmentation<PcepIetfStateful07Config>> augmentationType, Augmentation<PcepIetfStateful07Config> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PcepIetfStateful07Config>>, Augmentation<PcepIetfStateful07Config>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PcepIetfStateful07ConfigBuilder removeAugmentation(Class<? extends Augmentation<PcepIetfStateful07Config>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public PcepIetfStateful07Config build() {
        return new PcepIetfStateful07ConfigImpl(this);
    }

    private static final class PcepIetfStateful07ConfigImpl
    implements PcepIetfStateful07Config {
        private final Boolean _active;
        private final Boolean _deltaLspSyncCapability;
        private final Boolean _includeDbVersion;
        private final Boolean _initiated;
        private final Boolean _stateful;
        private final Boolean _triggeredInitialSync;
        private final Boolean _triggeredResync;
        private Map<Class<? extends Augmentation<PcepIetfStateful07Config>>, Augmentation<PcepIetfStateful07Config>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        private PcepIetfStateful07ConfigImpl(PcepIetfStateful07ConfigBuilder base) {
            this._active = base.isActive();
            this._deltaLspSyncCapability = base.isDeltaLspSyncCapability();
            this._includeDbVersion = base.isIncludeDbVersion();
            this._initiated = base.isInitiated();
            this._stateful = base.isStateful();
            this._triggeredInitialSync = base.isTriggeredInitialSync();
            this._triggeredResync = base.isTriggeredResync();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<PcepIetfStateful07Config> getImplementedInterface() {
            return PcepIetfStateful07Config.class;
        }

        @Override
        public Boolean isActive() {
            return this._active;
        }

        @Override
        public Boolean isDeltaLspSyncCapability() {
            return this._deltaLspSyncCapability;
        }

        @Override
        public Boolean isIncludeDbVersion() {
            return this._includeDbVersion;
        }

        @Override
        public Boolean isInitiated() {
            return this._initiated;
        }

        @Override
        public Boolean isStateful() {
            return this._stateful;
        }

        @Override
        public Boolean isTriggeredInitialSync() {
            return this._triggeredInitialSync;
        }

        @Override
        public Boolean isTriggeredResync() {
            return this._triggeredResync;
        }

        @Override
        public <E extends Augmentation<PcepIetfStateful07Config>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._active);
            result = 31 * result + Objects.hashCode(this._deltaLspSyncCapability);
            result = 31 * result + Objects.hashCode(this._includeDbVersion);
            result = 31 * result + Objects.hashCode(this._initiated);
            result = 31 * result + Objects.hashCode(this._stateful);
            result = 31 * result + Objects.hashCode(this._triggeredInitialSync);
            result = 31 * result + Objects.hashCode(this._triggeredResync);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PcepIetfStateful07Config.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PcepIetfStateful07Config other = (PcepIetfStateful07Config)obj;
            if (!Objects.equals(this._active, other.isActive())) {
                return false;
            }
            if (!Objects.equals(this._deltaLspSyncCapability, other.isDeltaLspSyncCapability())) {
                return false;
            }
            if (!Objects.equals(this._includeDbVersion, other.isIncludeDbVersion())) {
                return false;
            }
            if (!Objects.equals(this._initiated, other.isInitiated())) {
                return false;
            }
            if (!Objects.equals(this._stateful, other.isStateful())) {
                return false;
            }
            if (!Objects.equals(this._triggeredInitialSync, other.isTriggeredInitialSync())) {
                return false;
            }
            if (!Objects.equals(this._triggeredResync, other.isTriggeredResync())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PcepIetfStateful07ConfigImpl otherImpl = (PcepIetfStateful07ConfigImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PcepIetfStateful07Config>>, Augmentation<PcepIetfStateful07Config>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("PcepIetfStateful07Config");
            CodeHelpers.appendValue(helper, "_active", this._active);
            CodeHelpers.appendValue(helper, "_deltaLspSyncCapability", this._deltaLspSyncCapability);
            CodeHelpers.appendValue(helper, "_includeDbVersion", this._includeDbVersion);
            CodeHelpers.appendValue(helper, "_initiated", this._initiated);
            CodeHelpers.appendValue(helper, "_stateful", this._stateful);
            CodeHelpers.appendValue(helper, "_triggeredInitialSync", this._triggeredInitialSync);
            CodeHelpers.appendValue(helper, "_triggeredResync", this._triggeredResync);
            CodeHelpers.appendValue(helper, "augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

