/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ieee754.rev130819;

import com.google.common.base.MoreObjects;
import com.google.common.io.BaseEncoding;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

public class Float32
implements Serializable {
    private static final long serialVersionUID = -9133028837184821048L;
    private final byte[] _value;

    private static void check_valueLength(byte[] value) {
        int length = value.length;
        if (length == 4) {
            return;
        }
        CodeHelpers.throwInvalidLength("[[4..4]]", value);
    }

    @ConstructorProperties(value={"value"})
    public Float32(byte[] _value) {
        if (_value != null) {
            Float32.check_valueLength(_value);
        }
        Objects.requireNonNull(_value, "Supplied value may not be null");
        this._value = (byte[])_value.clone();
    }

    public Float32(Float32 source) {
        this._value = source._value;
    }

    public static Float32 getDefaultInstance(String defaultValue) {
        BaseEncoding baseEncoding = BaseEncoding.base64();
        return new Float32(baseEncoding.decode(defaultValue));
    }

    public byte[] getValue() {
        return this._value == null ? null : (byte[])this._value.clone();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this._value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Float32 other = (Float32)obj;
        return Arrays.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(Float32.class);
        CodeHelpers.appendValue(helper, "_value", this._value);
        return helper.toString();
    }
}

