/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.core.general.entity.rev150930;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.core.general.entity.rev150930.Entity;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.mdsal.core.general.entity.rev150930.EntityKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class EntityBuilder
implements Builder<Entity> {
    private String _name;
    private EntityKey key;
    Map<Class<? extends Augmentation<Entity>>, Augmentation<Entity>> augmentation = Collections.emptyMap();

    public EntityBuilder() {
    }

    public EntityBuilder(Entity base) {
        AugmentationHolder casted;
        if (base.key() == null) {
            this.key = new EntityKey(base.getName());
            this._name = base.getName();
        } else {
            this.key = base.key();
            this._name = this.key.getName();
        }
        if (base instanceof EntityImpl) {
            EntityImpl impl = (EntityImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Entity>>, Augmentation<Entity>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public EntityKey key() {
        return this.key;
    }

    public String getName() {
        return this._name;
    }

    public <E extends Augmentation<Entity>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public EntityBuilder withKey(EntityKey key) {
        this.key = key;
        return this;
    }

    public EntityBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public EntityBuilder addAugmentation(Class<? extends Augmentation<Entity>> augmentationType, Augmentation<Entity> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Entity>>, Augmentation<Entity>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public EntityBuilder removeAugmentation(Class<? extends Augmentation<Entity>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Entity build() {
        return new EntityImpl(this);
    }

    private static final class EntityImpl
    implements Entity {
        private final String _name;
        private final EntityKey key;
        private Map<Class<? extends Augmentation<Entity>>, Augmentation<Entity>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        private EntityImpl(EntityBuilder base) {
            if (base.key() == null) {
                this.key = new EntityKey(base.getName());
                this._name = base.getName();
            } else {
                this.key = base.key();
                this._name = this.key.getName();
            }
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Entity> getImplementedInterface() {
            return Entity.class;
        }

        @Override
        public EntityKey key() {
            return this.key;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public <E extends Augmentation<Entity>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._name);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Entity.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Entity other = (Entity)obj;
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                EntityImpl otherImpl = (EntityImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Entity>>, Augmentation<Entity>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Entity");
            CodeHelpers.appendValue(helper, "_name", this._name);
            CodeHelpers.appendValue(helper, "augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

