/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025;

import com.google.common.base.MoreObjects;
import com.google.common.io.BaseEncoding;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

public class SymbolicPathName
implements Serializable {
    private static final long serialVersionUID = -5688380084332043475L;
    private final byte[] _value;

    private static void check_valueLength(byte[] value) {
        int length = value.length;
        if (length >= 1 && length <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidLength("[[1..65535]]", value);
    }

    @ConstructorProperties(value={"value"})
    public SymbolicPathName(byte[] _value) {
        if (_value != null) {
            SymbolicPathName.check_valueLength(_value);
        }
        Objects.requireNonNull(_value, "Supplied value may not be null");
        this._value = (byte[])_value.clone();
    }

    public SymbolicPathName(SymbolicPathName source) {
        this._value = source._value;
    }

    public static SymbolicPathName getDefaultInstance(String defaultValue) {
        BaseEncoding baseEncoding = BaseEncoding.base64();
        return new SymbolicPathName(baseEncoding.decode(defaultValue));
    }

    public byte[] getValue() {
        return this._value == null ? null : (byte[])this._value.clone();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this._value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SymbolicPathName other = (SymbolicPathName)obj;
        return Arrays.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(SymbolicPathName.class);
        CodeHelpers.appendValue(helper, "_value", this._value);
        return helper.toString();
    }
}

