/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.lsp.object.lsp;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.LspErrorCodeTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.LspIdentifiersTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.PathBindingTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.RsvpErrorSpecTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.SymbolicPathNameTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.lsp.error.code.tlv.LspErrorCode;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.lsp.identifiers.tlv.LspIdentifiers;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.lsp.object.lsp.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.path.binding.tlv.PathBinding;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.rsvp.error.spec.tlv.RsvpErrorSpec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.symbolic.path.name.tlv.SymbolicPathName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformationTlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.tlvs.VendorInformationTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vs.tlv.VsTlv;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TlvsBuilder
implements Builder<Tlvs> {
    private LspErrorCode _lspErrorCode;
    private LspIdentifiers _lspIdentifiers;
    private PathBinding _pathBinding;
    private RsvpErrorSpec _rsvpErrorSpec;
    private SymbolicPathName _symbolicPathName;
    private List<VendorInformationTlv> _vendorInformationTlv;
    private VsTlv _vsTlv;
    Map<Class<? extends Augmentation<Tlvs>>, Augmentation<Tlvs>> augmentation = Collections.emptyMap();

    public TlvsBuilder() {
    }

    public TlvsBuilder(LspErrorCodeTlv arg) {
        this._lspErrorCode = arg.getLspErrorCode();
    }

    public TlvsBuilder(RsvpErrorSpecTlv arg) {
        this._rsvpErrorSpec = arg.getRsvpErrorSpec();
    }

    public TlvsBuilder(SymbolicPathNameTlv arg) {
        this._symbolicPathName = arg.getSymbolicPathName();
    }

    public TlvsBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VsTlv arg) {
        this._vsTlv = arg.getVsTlv();
    }

    public TlvsBuilder(VendorInformationTlvs arg) {
        this._vendorInformationTlv = arg.getVendorInformationTlv();
    }

    public TlvsBuilder(LspIdentifiersTlv arg) {
        this._lspIdentifiers = arg.getLspIdentifiers();
    }

    public TlvsBuilder(PathBindingTlv arg) {
        this._pathBinding = arg.getPathBinding();
    }

    public TlvsBuilder(Tlvs base) {
        AugmentationHolder casted;
        this._lspErrorCode = base.getLspErrorCode();
        this._lspIdentifiers = base.getLspIdentifiers();
        this._pathBinding = base.getPathBinding();
        this._rsvpErrorSpec = base.getRsvpErrorSpec();
        this._symbolicPathName = base.getSymbolicPathName();
        this._vendorInformationTlv = base.getVendorInformationTlv();
        this._vsTlv = base.getVsTlv();
        if (base instanceof TlvsImpl) {
            TlvsImpl impl = (TlvsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Tlvs>>, Augmentation<Tlvs>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SymbolicPathNameTlv) {
            this._symbolicPathName = ((SymbolicPathNameTlv)arg).getSymbolicPathName();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VsTlv) {
            this._vsTlv = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VsTlv)arg).getVsTlv();
            isValidArg = true;
        }
        if (arg instanceof PathBindingTlv) {
            this._pathBinding = ((PathBindingTlv)arg).getPathBinding();
            isValidArg = true;
        }
        if (arg instanceof RsvpErrorSpecTlv) {
            this._rsvpErrorSpec = ((RsvpErrorSpecTlv)arg).getRsvpErrorSpec();
            isValidArg = true;
        }
        if (arg instanceof VendorInformationTlvs) {
            this._vendorInformationTlv = ((VendorInformationTlvs)arg).getVendorInformationTlv();
            isValidArg = true;
        }
        if (arg instanceof LspIdentifiersTlv) {
            this._lspIdentifiers = ((LspIdentifiersTlv)arg).getLspIdentifiers();
            isValidArg = true;
        }
        if (arg instanceof LspErrorCodeTlv) {
            this._lspErrorCode = ((LspErrorCodeTlv)arg).getLspErrorCode();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.SymbolicPathNameTlv, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VsTlv, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.PathBindingTlv, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.RsvpErrorSpecTlv, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformationTlvs, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.LspIdentifiersTlv, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.LspErrorCodeTlv]");
    }

    public LspErrorCode getLspErrorCode() {
        return this._lspErrorCode;
    }

    public LspIdentifiers getLspIdentifiers() {
        return this._lspIdentifiers;
    }

    public PathBinding getPathBinding() {
        return this._pathBinding;
    }

    public RsvpErrorSpec getRsvpErrorSpec() {
        return this._rsvpErrorSpec;
    }

    public SymbolicPathName getSymbolicPathName() {
        return this._symbolicPathName;
    }

    public List<VendorInformationTlv> getVendorInformationTlv() {
        return this._vendorInformationTlv;
    }

    public VsTlv getVsTlv() {
        return this._vsTlv;
    }

    public <E extends Augmentation<Tlvs>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public TlvsBuilder setLspErrorCode(LspErrorCode value) {
        this._lspErrorCode = value;
        return this;
    }

    public TlvsBuilder setLspIdentifiers(LspIdentifiers value) {
        this._lspIdentifiers = value;
        return this;
    }

    public TlvsBuilder setPathBinding(PathBinding value) {
        this._pathBinding = value;
        return this;
    }

    public TlvsBuilder setRsvpErrorSpec(RsvpErrorSpec value) {
        this._rsvpErrorSpec = value;
        return this;
    }

    public TlvsBuilder setSymbolicPathName(SymbolicPathName value) {
        this._symbolicPathName = value;
        return this;
    }

    public TlvsBuilder setVendorInformationTlv(List<VendorInformationTlv> values) {
        this._vendorInformationTlv = values;
        return this;
    }

    public TlvsBuilder setVsTlv(VsTlv value) {
        this._vsTlv = value;
        return this;
    }

    public TlvsBuilder addAugmentation(Class<? extends Augmentation<Tlvs>> augmentationType, Augmentation<Tlvs> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Tlvs>>, Augmentation<Tlvs>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public TlvsBuilder removeAugmentation(Class<? extends Augmentation<Tlvs>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Tlvs build() {
        return new TlvsImpl(this);
    }

    private static final class TlvsImpl
    implements Tlvs {
        private final LspErrorCode _lspErrorCode;
        private final LspIdentifiers _lspIdentifiers;
        private final PathBinding _pathBinding;
        private final RsvpErrorSpec _rsvpErrorSpec;
        private final SymbolicPathName _symbolicPathName;
        private final List<VendorInformationTlv> _vendorInformationTlv;
        private final VsTlv _vsTlv;
        private Map<Class<? extends Augmentation<Tlvs>>, Augmentation<Tlvs>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        private TlvsImpl(TlvsBuilder base) {
            this._lspErrorCode = base.getLspErrorCode();
            this._lspIdentifiers = base.getLspIdentifiers();
            this._pathBinding = base.getPathBinding();
            this._rsvpErrorSpec = base.getRsvpErrorSpec();
            this._symbolicPathName = base.getSymbolicPathName();
            this._vendorInformationTlv = base.getVendorInformationTlv();
            this._vsTlv = base.getVsTlv();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Tlvs> getImplementedInterface() {
            return Tlvs.class;
        }

        @Override
        public LspErrorCode getLspErrorCode() {
            return this._lspErrorCode;
        }

        @Override
        public LspIdentifiers getLspIdentifiers() {
            return this._lspIdentifiers;
        }

        @Override
        public PathBinding getPathBinding() {
            return this._pathBinding;
        }

        @Override
        public RsvpErrorSpec getRsvpErrorSpec() {
            return this._rsvpErrorSpec;
        }

        @Override
        public SymbolicPathName getSymbolicPathName() {
            return this._symbolicPathName;
        }

        @Override
        public List<VendorInformationTlv> getVendorInformationTlv() {
            return this._vendorInformationTlv;
        }

        @Override
        public VsTlv getVsTlv() {
            return this._vsTlv;
        }

        @Override
        public <E extends Augmentation<Tlvs>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._lspErrorCode);
            result = 31 * result + Objects.hashCode(this._lspIdentifiers);
            result = 31 * result + Objects.hashCode(this._pathBinding);
            result = 31 * result + Objects.hashCode(this._rsvpErrorSpec);
            result = 31 * result + Objects.hashCode(this._symbolicPathName);
            result = 31 * result + Objects.hashCode(this._vendorInformationTlv);
            result = 31 * result + Objects.hashCode(this._vsTlv);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Tlvs.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Tlvs other = (Tlvs)obj;
            if (!Objects.equals(this._lspErrorCode, other.getLspErrorCode())) {
                return false;
            }
            if (!Objects.equals(this._lspIdentifiers, other.getLspIdentifiers())) {
                return false;
            }
            if (!Objects.equals(this._pathBinding, other.getPathBinding())) {
                return false;
            }
            if (!Objects.equals(this._rsvpErrorSpec, other.getRsvpErrorSpec())) {
                return false;
            }
            if (!Objects.equals(this._symbolicPathName, other.getSymbolicPathName())) {
                return false;
            }
            if (!Objects.equals(this._vendorInformationTlv, other.getVendorInformationTlv())) {
                return false;
            }
            if (!Objects.equals(this._vsTlv, other.getVsTlv())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TlvsImpl otherImpl = (TlvsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Tlvs>>, Augmentation<Tlvs>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Tlvs");
            CodeHelpers.appendValue(helper, "_lspErrorCode", this._lspErrorCode);
            CodeHelpers.appendValue(helper, "_lspIdentifiers", this._lspIdentifiers);
            CodeHelpers.appendValue(helper, "_pathBinding", this._pathBinding);
            CodeHelpers.appendValue(helper, "_rsvpErrorSpec", this._rsvpErrorSpec);
            CodeHelpers.appendValue(helper, "_symbolicPathName", this._symbolicPathName);
            CodeHelpers.appendValue(helper, "_vendorInformationTlv", this._vendorInformationTlv);
            CodeHelpers.appendValue(helper, "_vsTlv", this._vsTlv);
            CodeHelpers.appendValue(helper, "augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

