/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.path.binding.tlv.path.binding.binding.type.value;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.MplsLabel;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.path.binding.tlv.path.binding.binding.type.value.MplsLabelEntry;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MplsLabelEntryBuilder
implements Builder<MplsLabelEntry> {
    private MplsLabel _label;
    private Short _timeToLive;
    private Short _trafficClass;
    private Boolean _bottomOfStack;
    Map<Class<? extends Augmentation<MplsLabelEntry>>, Augmentation<MplsLabelEntry>> augmentation = Collections.emptyMap();

    public MplsLabelEntryBuilder() {
    }

    public MplsLabelEntryBuilder(MplsLabelEntry base) {
        AugmentationHolder casted;
        this._label = base.getLabel();
        this._timeToLive = base.getTimeToLive();
        this._trafficClass = base.getTrafficClass();
        this._bottomOfStack = base.isBottomOfStack();
        if (base instanceof MplsLabelEntryImpl) {
            MplsLabelEntryImpl impl = (MplsLabelEntryImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<MplsLabelEntry>>, Augmentation<MplsLabelEntry>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public MplsLabel getLabel() {
        return this._label;
    }

    public Short getTimeToLive() {
        return this._timeToLive;
    }

    public Short getTrafficClass() {
        return this._trafficClass;
    }

    public Boolean isBottomOfStack() {
        return this._bottomOfStack;
    }

    public <E extends Augmentation<MplsLabelEntry>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public MplsLabelEntryBuilder setLabel(MplsLabel value) {
        this._label = value;
        return this;
    }

    private static void checkTimeToLiveRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..255]]", (Object)value);
    }

    public MplsLabelEntryBuilder setTimeToLive(Short value) {
        if (value != null) {
            MplsLabelEntryBuilder.checkTimeToLiveRange(value);
        }
        this._timeToLive = value;
        return this;
    }

    private static void checkTrafficClassRange(short value) {
        if (value >= 0 && value <= 7) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..7]]", (Object)value);
    }

    public MplsLabelEntryBuilder setTrafficClass(Short value) {
        if (value != null) {
            MplsLabelEntryBuilder.checkTrafficClassRange(value);
        }
        this._trafficClass = value;
        return this;
    }

    public MplsLabelEntryBuilder setBottomOfStack(Boolean value) {
        this._bottomOfStack = value;
        return this;
    }

    public MplsLabelEntryBuilder addAugmentation(Class<? extends Augmentation<MplsLabelEntry>> augmentationType, Augmentation<MplsLabelEntry> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<MplsLabelEntry>>, Augmentation<MplsLabelEntry>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public MplsLabelEntryBuilder removeAugmentation(Class<? extends Augmentation<MplsLabelEntry>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public MplsLabelEntry build() {
        return new MplsLabelEntryImpl(this);
    }

    private static final class MplsLabelEntryImpl
    implements MplsLabelEntry {
        private final MplsLabel _label;
        private final Short _timeToLive;
        private final Short _trafficClass;
        private final Boolean _bottomOfStack;
        private Map<Class<? extends Augmentation<MplsLabelEntry>>, Augmentation<MplsLabelEntry>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        private MplsLabelEntryImpl(MplsLabelEntryBuilder base) {
            this._label = base.getLabel();
            this._timeToLive = base.getTimeToLive();
            this._trafficClass = base.getTrafficClass();
            this._bottomOfStack = base.isBottomOfStack();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<MplsLabelEntry> getImplementedInterface() {
            return MplsLabelEntry.class;
        }

        @Override
        public MplsLabel getLabel() {
            return this._label;
        }

        @Override
        public Short getTimeToLive() {
            return this._timeToLive;
        }

        @Override
        public Short getTrafficClass() {
            return this._trafficClass;
        }

        @Override
        public Boolean isBottomOfStack() {
            return this._bottomOfStack;
        }

        @Override
        public <E extends Augmentation<MplsLabelEntry>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._label);
            result = 31 * result + Objects.hashCode(this._timeToLive);
            result = 31 * result + Objects.hashCode(this._trafficClass);
            result = 31 * result + Objects.hashCode(this._bottomOfStack);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!MplsLabelEntry.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            MplsLabelEntry other = (MplsLabelEntry)obj;
            if (!Objects.equals(this._label, other.getLabel())) {
                return false;
            }
            if (!Objects.equals(this._timeToLive, other.getTimeToLive())) {
                return false;
            }
            if (!Objects.equals(this._trafficClass, other.getTrafficClass())) {
                return false;
            }
            if (!Objects.equals(this._bottomOfStack, other.isBottomOfStack())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MplsLabelEntryImpl otherImpl = (MplsLabelEntryImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<MplsLabelEntry>>, Augmentation<MplsLabelEntry>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("MplsLabelEntry");
            CodeHelpers.appendValue(helper, "_label", this._label);
            CodeHelpers.appendValue(helper, "_timeToLive", this._timeToLive);
            CodeHelpers.appendValue(helper, "_trafficClass", this._trafficClass);
            CodeHelpers.appendValue(helper, "_bottomOfStack", this._bottomOfStack);
            CodeHelpers.appendValue(helper, "augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

