/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.pcupd.message.pcupd.message;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.LspObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.SrpObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.lsp.object.Lsp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.pcupd.message.pcupd.message.Updates;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.pcupd.message.pcupd.message.updates.Path;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.srp.object.Srp;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class UpdatesBuilder
implements Builder<Updates> {
    private Lsp _lsp;
    private Path _path;
    private Srp _srp;
    Map<Class<? extends Augmentation<Updates>>, Augmentation<Updates>> augmentation = Collections.emptyMap();

    public UpdatesBuilder() {
    }

    public UpdatesBuilder(SrpObject arg) {
        this._srp = arg.getSrp();
    }

    public UpdatesBuilder(LspObject arg) {
        this._lsp = arg.getLsp();
    }

    public UpdatesBuilder(Updates base) {
        AugmentationHolder casted;
        this._lsp = base.getLsp();
        this._path = base.getPath();
        this._srp = base.getSrp();
        if (base instanceof UpdatesImpl) {
            UpdatesImpl impl = (UpdatesImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Updates>>, Augmentation<Updates>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SrpObject) {
            this._srp = ((SrpObject)arg).getSrp();
            isValidArg = true;
        }
        if (arg instanceof LspObject) {
            this._lsp = ((LspObject)arg).getLsp();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.SrpObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.LspObject]");
    }

    public Lsp getLsp() {
        return this._lsp;
    }

    public Path getPath() {
        return this._path;
    }

    public Srp getSrp() {
        return this._srp;
    }

    public <E extends Augmentation<Updates>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public UpdatesBuilder setLsp(Lsp value) {
        this._lsp = value;
        return this;
    }

    public UpdatesBuilder setPath(Path value) {
        this._path = value;
        return this;
    }

    public UpdatesBuilder setSrp(Srp value) {
        this._srp = value;
        return this;
    }

    public UpdatesBuilder addAugmentation(Class<? extends Augmentation<Updates>> augmentationType, Augmentation<Updates> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Updates>>, Augmentation<Updates>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public UpdatesBuilder removeAugmentation(Class<? extends Augmentation<Updates>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Updates build() {
        return new UpdatesImpl(this);
    }

    private static final class UpdatesImpl
    implements Updates {
        private final Lsp _lsp;
        private final Path _path;
        private final Srp _srp;
        private Map<Class<? extends Augmentation<Updates>>, Augmentation<Updates>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        private UpdatesImpl(UpdatesBuilder base) {
            this._lsp = base.getLsp();
            this._path = base.getPath();
            this._srp = base.getSrp();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Updates> getImplementedInterface() {
            return Updates.class;
        }

        @Override
        public Lsp getLsp() {
            return this._lsp;
        }

        @Override
        public Path getPath() {
            return this._path;
        }

        @Override
        public Srp getSrp() {
            return this._srp;
        }

        @Override
        public <E extends Augmentation<Updates>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._lsp);
            result = 31 * result + Objects.hashCode(this._path);
            result = 31 * result + Objects.hashCode(this._srp);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Updates.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Updates other = (Updates)obj;
            if (!Objects.equals(this._lsp, other.getLsp())) {
                return false;
            }
            if (!Objects.equals(this._path, other.getPath())) {
                return false;
            }
            if (!Objects.equals(this._srp, other.getSrp())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                UpdatesImpl otherImpl = (UpdatesImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Updates>>, Augmentation<Updates>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Updates");
            CodeHelpers.appendValue(helper, "_lsp", this._lsp);
            CodeHelpers.appendValue(helper, "_path", this._path);
            CodeHelpers.appendValue(helper, "_srp", this._srp);
            CodeHelpers.appendValue(helper, "augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

