/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.rsvp.error.spec.tlv.rsvp.error.spec.error.type.user._case;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.iana.rev130816.EnterpriseNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.ietf.stateful.rev171025.rsvp.error.spec.tlv.rsvp.error.spec.error.type.user._case.UserError;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.UserErrorSpec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.user.error.spec.Subobjects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class UserErrorBuilder
implements Builder<UserError> {
    private String _description;
    private EnterpriseNumber _enterprise;
    private Short _subOrg;
    private Subobjects _subobjects;
    private Integer _value;
    Map<Class<? extends Augmentation<UserError>>, Augmentation<UserError>> augmentation = Collections.emptyMap();

    public UserErrorBuilder() {
    }

    public UserErrorBuilder(UserErrorSpec arg) {
        this._enterprise = arg.getEnterprise();
        this._subOrg = arg.getSubOrg();
        this._value = arg.getValue();
        this._description = arg.getDescription();
        this._subobjects = arg.getSubobjects();
    }

    public UserErrorBuilder(UserError base) {
        AugmentationHolder casted;
        this._description = base.getDescription();
        this._enterprise = base.getEnterprise();
        this._subOrg = base.getSubOrg();
        this._subobjects = base.getSubobjects();
        this._value = base.getValue();
        if (base instanceof UserErrorImpl) {
            UserErrorImpl impl = (UserErrorImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<UserError>>, Augmentation<UserError>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof UserErrorSpec) {
            this._enterprise = ((UserErrorSpec)arg).getEnterprise();
            this._subOrg = ((UserErrorSpec)arg).getSubOrg();
            this._value = ((UserErrorSpec)arg).getValue();
            this._description = ((UserErrorSpec)arg).getDescription();
            this._subobjects = ((UserErrorSpec)arg).getSubobjects();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.UserErrorSpec]");
    }

    public String getDescription() {
        return this._description;
    }

    public EnterpriseNumber getEnterprise() {
        return this._enterprise;
    }

    public Short getSubOrg() {
        return this._subOrg;
    }

    public Subobjects getSubobjects() {
        return this._subobjects;
    }

    public Integer getValue() {
        return this._value;
    }

    public <E extends Augmentation<UserError>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public UserErrorBuilder setDescription(String value) {
        this._description = value;
        return this;
    }

    public UserErrorBuilder setEnterprise(EnterpriseNumber value) {
        this._enterprise = value;
        return this;
    }

    private static void checkSubOrgRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..255]]", (Object)value);
    }

    public UserErrorBuilder setSubOrg(Short value) {
        if (value != null) {
            UserErrorBuilder.checkSubOrgRange(value);
        }
        this._subOrg = value;
        return this;
    }

    public UserErrorBuilder setSubobjects(Subobjects value) {
        this._subobjects = value;
        return this;
    }

    private static void checkValueRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", (Object)value);
    }

    public UserErrorBuilder setValue(Integer value) {
        if (value != null) {
            UserErrorBuilder.checkValueRange(value);
        }
        this._value = value;
        return this;
    }

    public UserErrorBuilder addAugmentation(Class<? extends Augmentation<UserError>> augmentationType, Augmentation<UserError> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<UserError>>, Augmentation<UserError>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public UserErrorBuilder removeAugmentation(Class<? extends Augmentation<UserError>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public UserError build() {
        return new UserErrorImpl(this);
    }

    private static final class UserErrorImpl
    implements UserError {
        private final String _description;
        private final EnterpriseNumber _enterprise;
        private final Short _subOrg;
        private final Subobjects _subobjects;
        private final Integer _value;
        private Map<Class<? extends Augmentation<UserError>>, Augmentation<UserError>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        private UserErrorImpl(UserErrorBuilder base) {
            this._description = base.getDescription();
            this._enterprise = base.getEnterprise();
            this._subOrg = base.getSubOrg();
            this._subobjects = base.getSubobjects();
            this._value = base.getValue();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<UserError> getImplementedInterface() {
            return UserError.class;
        }

        @Override
        public String getDescription() {
            return this._description;
        }

        @Override
        public EnterpriseNumber getEnterprise() {
            return this._enterprise;
        }

        @Override
        public Short getSubOrg() {
            return this._subOrg;
        }

        @Override
        public Subobjects getSubobjects() {
            return this._subobjects;
        }

        @Override
        public Integer getValue() {
            return this._value;
        }

        @Override
        public <E extends Augmentation<UserError>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._description);
            result = 31 * result + Objects.hashCode(this._enterprise);
            result = 31 * result + Objects.hashCode(this._subOrg);
            result = 31 * result + Objects.hashCode(this._subobjects);
            result = 31 * result + Objects.hashCode(this._value);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!UserError.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            UserError other = (UserError)obj;
            if (!Objects.equals(this._description, other.getDescription())) {
                return false;
            }
            if (!Objects.equals(this._enterprise, other.getEnterprise())) {
                return false;
            }
            if (!Objects.equals(this._subOrg, other.getSubOrg())) {
                return false;
            }
            if (!Objects.equals(this._subobjects, other.getSubobjects())) {
                return false;
            }
            if (!Objects.equals(this._value, other.getValue())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                UserErrorImpl otherImpl = (UserErrorImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<UserError>>, Augmentation<UserError>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("UserError");
            CodeHelpers.appendValue(helper, "_description", this._description);
            CodeHelpers.appendValue(helper, "_enterprise", this._enterprise);
            CodeHelpers.appendValue(helper, "_subOrg", this._subOrg);
            CodeHelpers.appendValue(helper, "_subobjects", this._subobjects);
            CodeHelpers.appendValue(helper, "_value", this._value);
            CodeHelpers.appendValue(helper, "augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

