/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.Preferences;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.PeerPref;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PeerPrefBuilder
implements Builder<PeerPref> {
    private Short _deadtimer;
    private String _ipAddress;
    private Short _keepalive;
    private Integer _sessionId;
    Map<Class<? extends Augmentation<PeerPref>>, Augmentation<PeerPref>> augmentation = Collections.emptyMap();

    public PeerPrefBuilder() {
    }

    public PeerPrefBuilder(Preferences arg) {
        this._keepalive = arg.getKeepalive();
        this._deadtimer = arg.getDeadtimer();
        this._ipAddress = arg.getIpAddress();
        this._sessionId = arg.getSessionId();
    }

    public PeerPrefBuilder(PeerPref base) {
        AugmentationHolder casted;
        this._deadtimer = base.getDeadtimer();
        this._ipAddress = base.getIpAddress();
        this._keepalive = base.getKeepalive();
        this._sessionId = base.getSessionId();
        if (base instanceof PeerPrefImpl) {
            PeerPrefImpl impl = (PeerPrefImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PeerPref>>, Augmentation<PeerPref>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Preferences) {
            this._keepalive = ((Preferences)arg).getKeepalive();
            this._deadtimer = ((Preferences)arg).getDeadtimer();
            this._ipAddress = ((Preferences)arg).getIpAddress();
            this._sessionId = ((Preferences)arg).getSessionId();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.Preferences]");
    }

    public Short getDeadtimer() {
        return this._deadtimer;
    }

    public String getIpAddress() {
        return this._ipAddress;
    }

    public Short getKeepalive() {
        return this._keepalive;
    }

    public Integer getSessionId() {
        return this._sessionId;
    }

    public <E extends Augmentation<PeerPref>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkDeadtimerRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..255]]", (Object)value);
    }

    public PeerPrefBuilder setDeadtimer(Short value) {
        if (value != null) {
            PeerPrefBuilder.checkDeadtimerRange(value);
        }
        this._deadtimer = value;
        return this;
    }

    public PeerPrefBuilder setIpAddress(String value) {
        this._ipAddress = value;
        return this;
    }

    private static void checkKeepaliveRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..255]]", (Object)value);
    }

    public PeerPrefBuilder setKeepalive(Short value) {
        if (value != null) {
            PeerPrefBuilder.checkKeepaliveRange(value);
        }
        this._keepalive = value;
        return this;
    }

    private static void checkSessionIdRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", (Object)value);
    }

    public PeerPrefBuilder setSessionId(Integer value) {
        if (value != null) {
            PeerPrefBuilder.checkSessionIdRange(value);
        }
        this._sessionId = value;
        return this;
    }

    public PeerPrefBuilder addAugmentation(Class<? extends Augmentation<PeerPref>> augmentationType, Augmentation<PeerPref> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PeerPref>>, Augmentation<PeerPref>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PeerPrefBuilder removeAugmentation(Class<? extends Augmentation<PeerPref>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public PeerPref build() {
        return new PeerPrefImpl(this);
    }

    private static final class PeerPrefImpl
    implements PeerPref {
        private final Short _deadtimer;
        private final String _ipAddress;
        private final Short _keepalive;
        private final Integer _sessionId;
        private Map<Class<? extends Augmentation<PeerPref>>, Augmentation<PeerPref>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        private PeerPrefImpl(PeerPrefBuilder base) {
            this._deadtimer = base.getDeadtimer();
            this._ipAddress = base.getIpAddress();
            this._keepalive = base.getKeepalive();
            this._sessionId = base.getSessionId();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<PeerPref> getImplementedInterface() {
            return PeerPref.class;
        }

        @Override
        public Short getDeadtimer() {
            return this._deadtimer;
        }

        @Override
        public String getIpAddress() {
            return this._ipAddress;
        }

        @Override
        public Short getKeepalive() {
            return this._keepalive;
        }

        @Override
        public Integer getSessionId() {
            return this._sessionId;
        }

        @Override
        public <E extends Augmentation<PeerPref>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._deadtimer);
            result = 31 * result + Objects.hashCode(this._ipAddress);
            result = 31 * result + Objects.hashCode(this._keepalive);
            result = 31 * result + Objects.hashCode(this._sessionId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PeerPref.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PeerPref other = (PeerPref)obj;
            if (!Objects.equals(this._deadtimer, other.getDeadtimer())) {
                return false;
            }
            if (!Objects.equals(this._ipAddress, other.getIpAddress())) {
                return false;
            }
            if (!Objects.equals(this._keepalive, other.getKeepalive())) {
                return false;
            }
            if (!Objects.equals(this._sessionId, other.getSessionId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PeerPrefImpl otherImpl = (PeerPrefImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PeerPref>>, Augmentation<PeerPref>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("PeerPref");
            CodeHelpers.appendValue(helper, "_deadtimer", this._deadtimer);
            CodeHelpers.appendValue(helper, "_ipAddress", this._ipAddress);
            CodeHelpers.appendValue(helper, "_keepalive", this._keepalive);
            CodeHelpers.appendValue(helper, "_sessionId", this._sessionId);
            CodeHelpers.appendValue(helper, "augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

