/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005;

import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

public class RequestId
implements Serializable {
    private static final long serialVersionUID = 3068263630509172403L;
    private final Long _value;

    private static void check_valueRange(long value) {
        if (value >= 1L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[1..4294967295]]", (Object)value);
    }

    @ConstructorProperties(value={"value"})
    public RequestId(Long _value) {
        if (_value != null) {
            RequestId.check_valueRange(_value);
        }
        Objects.requireNonNull(_value, "Supplied value may not be null");
        this._value = _value;
    }

    public RequestId(RequestId source) {
        this._value = source._value;
    }

    public static RequestId getDefaultInstance(String defaultValue) {
        return new RequestId(Long.valueOf(defaultValue));
    }

    public Long getValue() {
        return this._value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestId other = (RequestId)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(RequestId.class);
        CodeHelpers.appendValue(helper, "_value", this._value);
        return helper.toString();
    }
}

