/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.keepalive.message;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MessageHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ProtocolVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.keepalive.message.KeepaliveMessage;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class KeepaliveMessageBuilder
implements Builder<KeepaliveMessage> {
    private ProtocolVersion _version;
    Map<Class<? extends Augmentation<KeepaliveMessage>>, Augmentation<KeepaliveMessage>> augmentation = Collections.emptyMap();

    public KeepaliveMessageBuilder() {
    }

    public KeepaliveMessageBuilder(MessageHeader arg) {
        this._version = arg.getVersion();
    }

    public KeepaliveMessageBuilder(KeepaliveMessage base) {
        AugmentationHolder casted;
        this._version = base.getVersion();
        if (base instanceof KeepaliveMessageImpl) {
            KeepaliveMessageImpl impl = (KeepaliveMessageImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<KeepaliveMessage>>, Augmentation<KeepaliveMessage>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof MessageHeader) {
            this._version = ((MessageHeader)arg).getVersion();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MessageHeader]");
    }

    public ProtocolVersion getVersion() {
        return this._version;
    }

    public <E extends Augmentation<KeepaliveMessage>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public KeepaliveMessageBuilder setVersion(ProtocolVersion value) {
        this._version = value;
        return this;
    }

    public KeepaliveMessageBuilder addAugmentation(Class<? extends Augmentation<KeepaliveMessage>> augmentationType, Augmentation<KeepaliveMessage> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<KeepaliveMessage>>, Augmentation<KeepaliveMessage>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public KeepaliveMessageBuilder removeAugmentation(Class<? extends Augmentation<KeepaliveMessage>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public KeepaliveMessage build() {
        return new KeepaliveMessageImpl(this);
    }

    private static final class KeepaliveMessageImpl
    implements KeepaliveMessage {
        private final ProtocolVersion _version;
        private Map<Class<? extends Augmentation<KeepaliveMessage>>, Augmentation<KeepaliveMessage>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        private KeepaliveMessageImpl(KeepaliveMessageBuilder base) {
            this._version = base.getVersion();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<KeepaliveMessage> getImplementedInterface() {
            return KeepaliveMessage.class;
        }

        @Override
        public ProtocolVersion getVersion() {
            return this._version;
        }

        @Override
        public <E extends Augmentation<KeepaliveMessage>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._version);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!KeepaliveMessage.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            KeepaliveMessage other = (KeepaliveMessage)obj;
            if (!Objects.equals(this._version, other.getVersion())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                KeepaliveMessageImpl otherImpl = (KeepaliveMessageImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<KeepaliveMessage>>, Augmentation<KeepaliveMessage>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("KeepaliveMessage");
            CodeHelpers.appendValue(helper, "_version", this._version);
            CodeHelpers.appendValue(helper, "augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

