/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.metric.object;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ieee754.rev130819.Float32;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.metric.object.Metric;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class MetricBuilder
implements Builder<Metric> {
    private Short _metricType;
    private Float32 _value;
    private Boolean _bound;
    private Boolean _computed;
    private Boolean _ignore;
    private Boolean _processingRule;
    Map<Class<? extends Augmentation<Metric>>, Augmentation<Metric>> augmentation = Collections.emptyMap();

    public MetricBuilder() {
    }

    public MetricBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public MetricBuilder(Metric base) {
        AugmentationHolder casted;
        this._metricType = base.getMetricType();
        this._value = base.getValue();
        this._bound = base.isBound();
        this._computed = base.isComputed();
        this._ignore = base.isIgnore();
        this._processingRule = base.isProcessingRule();
        if (base instanceof MetricImpl) {
            MetricImpl impl = (MetricImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Metric>>, Augmentation<Metric>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader]");
    }

    public Short getMetricType() {
        return this._metricType;
    }

    public Float32 getValue() {
        return this._value;
    }

    public Boolean isBound() {
        return this._bound;
    }

    public Boolean isComputed() {
        return this._computed;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public <E extends Augmentation<Metric>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkMetricTypeRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..255]]", (Object)value);
    }

    public MetricBuilder setMetricType(Short value) {
        if (value != null) {
            MetricBuilder.checkMetricTypeRange(value);
        }
        this._metricType = value;
        return this;
    }

    public MetricBuilder setValue(Float32 value) {
        this._value = value;
        return this;
    }

    public MetricBuilder setBound(Boolean value) {
        this._bound = value;
        return this;
    }

    public MetricBuilder setComputed(Boolean value) {
        this._computed = value;
        return this;
    }

    public MetricBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public MetricBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public MetricBuilder addAugmentation(Class<? extends Augmentation<Metric>> augmentationType, Augmentation<Metric> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Metric>>, Augmentation<Metric>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public MetricBuilder removeAugmentation(Class<? extends Augmentation<Metric>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Metric build() {
        return new MetricImpl(this);
    }

    private static final class MetricImpl
    implements Metric {
        private final Short _metricType;
        private final Float32 _value;
        private final Boolean _bound;
        private final Boolean _computed;
        private final Boolean _ignore;
        private final Boolean _processingRule;
        private Map<Class<? extends Augmentation<Metric>>, Augmentation<Metric>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        private MetricImpl(MetricBuilder base) {
            this._metricType = base.getMetricType();
            this._value = base.getValue();
            this._bound = base.isBound();
            this._computed = base.isComputed();
            this._ignore = base.isIgnore();
            this._processingRule = base.isProcessingRule();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Metric> getImplementedInterface() {
            return Metric.class;
        }

        @Override
        public Short getMetricType() {
            return this._metricType;
        }

        @Override
        public Float32 getValue() {
            return this._value;
        }

        @Override
        public Boolean isBound() {
            return this._bound;
        }

        @Override
        public Boolean isComputed() {
            return this._computed;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        @Override
        public <E extends Augmentation<Metric>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._metricType);
            result = 31 * result + Objects.hashCode(this._value);
            result = 31 * result + Objects.hashCode(this._bound);
            result = 31 * result + Objects.hashCode(this._computed);
            result = 31 * result + Objects.hashCode(this._ignore);
            result = 31 * result + Objects.hashCode(this._processingRule);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Metric.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Metric other = (Metric)obj;
            if (!Objects.equals(this._metricType, other.getMetricType())) {
                return false;
            }
            if (!Objects.equals(this._value, other.getValue())) {
                return false;
            }
            if (!Objects.equals(this._bound, other.isBound())) {
                return false;
            }
            if (!Objects.equals(this._computed, other.isComputed())) {
                return false;
            }
            if (!Objects.equals(this._ignore, other.isIgnore())) {
                return false;
            }
            if (!Objects.equals(this._processingRule, other.isProcessingRule())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                MetricImpl otherImpl = (MetricImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Metric>>, Augmentation<Metric>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Metric");
            CodeHelpers.appendValue(helper, "_metricType", this._metricType);
            CodeHelpers.appendValue(helper, "_value", this._value);
            CodeHelpers.appendValue(helper, "_bound", this._bound);
            CodeHelpers.appendValue(helper, "_computed", this._computed);
            CodeHelpers.appendValue(helper, "_ignore", this._ignore);
            CodeHelpers.appendValue(helper, "_processingRule", this._processingRule);
            CodeHelpers.appendValue(helper, "augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

