/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.of.list.tlv;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OfId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.of.list.tlv.OfList;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class OfListBuilder
implements Builder<OfList> {
    private List<OfId> _codes;
    Map<Class<? extends Augmentation<OfList>>, Augmentation<OfList>> augmentation = Collections.emptyMap();

    public OfListBuilder() {
    }

    public OfListBuilder(OfList base) {
        AugmentationHolder casted;
        this._codes = base.getCodes();
        if (base instanceof OfListImpl) {
            OfListImpl impl = (OfListImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<OfList>>, Augmentation<OfList>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public List<OfId> getCodes() {
        return this._codes;
    }

    public <E extends Augmentation<OfList>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public OfListBuilder setCodes(List<OfId> values) {
        this._codes = values;
        return this;
    }

    public OfListBuilder addAugmentation(Class<? extends Augmentation<OfList>> augmentationType, Augmentation<OfList> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OfList>>, Augmentation<OfList>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public OfListBuilder removeAugmentation(Class<? extends Augmentation<OfList>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public OfList build() {
        return new OfListImpl(this);
    }

    private static final class OfListImpl
    implements OfList {
        private final List<OfId> _codes;
        private Map<Class<? extends Augmentation<OfList>>, Augmentation<OfList>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        private OfListImpl(OfListBuilder base) {
            this._codes = base.getCodes();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<OfList> getImplementedInterface() {
            return OfList.class;
        }

        @Override
        public List<OfId> getCodes() {
            return this._codes;
        }

        @Override
        public <E extends Augmentation<OfList>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._codes);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!OfList.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            OfList other = (OfList)obj;
            if (!Objects.equals(this._codes, other.getCodes())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                OfListImpl otherImpl = (OfListImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<OfList>>, Augmentation<OfList>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("OfList");
            CodeHelpers.appendValue(helper, "_codes", this._codes);
            CodeHelpers.appendValue(helper, "augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

