/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.message;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MessageHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OpenObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ProtocolVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.message.OpenMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.open.object.Open;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class OpenMessageBuilder
implements Builder<OpenMessage> {
    private Open _open;
    private ProtocolVersion _version;
    Map<Class<? extends Augmentation<OpenMessage>>, Augmentation<OpenMessage>> augmentation = Collections.emptyMap();

    public OpenMessageBuilder() {
    }

    public OpenMessageBuilder(OpenObject arg) {
        this._open = arg.getOpen();
    }

    public OpenMessageBuilder(MessageHeader arg) {
        this._version = arg.getVersion();
    }

    public OpenMessageBuilder(OpenMessage base) {
        AugmentationHolder casted;
        this._open = base.getOpen();
        this._version = base.getVersion();
        if (base instanceof OpenMessageImpl) {
            OpenMessageImpl impl = (OpenMessageImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<OpenMessage>>, Augmentation<OpenMessage>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof OpenObject) {
            this._open = ((OpenObject)arg).getOpen();
            isValidArg = true;
        }
        if (arg instanceof MessageHeader) {
            this._version = ((MessageHeader)arg).getVersion();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OpenObject, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.MessageHeader]");
    }

    public Open getOpen() {
        return this._open;
    }

    public ProtocolVersion getVersion() {
        return this._version;
    }

    public <E extends Augmentation<OpenMessage>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public OpenMessageBuilder setOpen(Open value) {
        this._open = value;
        return this;
    }

    public OpenMessageBuilder setVersion(ProtocolVersion value) {
        this._version = value;
        return this;
    }

    public OpenMessageBuilder addAugmentation(Class<? extends Augmentation<OpenMessage>> augmentationType, Augmentation<OpenMessage> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<OpenMessage>>, Augmentation<OpenMessage>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public OpenMessageBuilder removeAugmentation(Class<? extends Augmentation<OpenMessage>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public OpenMessage build() {
        return new OpenMessageImpl(this);
    }

    private static final class OpenMessageImpl
    implements OpenMessage {
        private final Open _open;
        private final ProtocolVersion _version;
        private Map<Class<? extends Augmentation<OpenMessage>>, Augmentation<OpenMessage>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        private OpenMessageImpl(OpenMessageBuilder base) {
            this._open = base.getOpen();
            this._version = base.getVersion();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<OpenMessage> getImplementedInterface() {
            return OpenMessage.class;
        }

        @Override
        public Open getOpen() {
            return this._open;
        }

        @Override
        public ProtocolVersion getVersion() {
            return this._version;
        }

        @Override
        public <E extends Augmentation<OpenMessage>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._open);
            result = 31 * result + Objects.hashCode(this._version);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!OpenMessage.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            OpenMessage other = (OpenMessage)obj;
            if (!Objects.equals(this._open, other.getOpen())) {
                return false;
            }
            if (!Objects.equals(this._version, other.getVersion())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                OpenMessageImpl otherImpl = (OpenMessageImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<OpenMessage>>, Augmentation<OpenMessage>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("OpenMessage");
            CodeHelpers.appendValue(helper, "_open", this._open);
            CodeHelpers.appendValue(helper, "_version", this._version);
            CodeHelpers.appendValue(helper, "augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

