/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.order.tlv;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.order.tlv.Order;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class OrderBuilder
implements Builder<Order> {
    private Long _delete;
    private Long _setup;
    Map<Class<? extends Augmentation<Order>>, Augmentation<Order>> augmentation = Collections.emptyMap();

    public OrderBuilder() {
    }

    public OrderBuilder(Order base) {
        AugmentationHolder casted;
        this._delete = base.getDelete();
        this._setup = base.getSetup();
        if (base instanceof OrderImpl) {
            OrderImpl impl = (OrderImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Order>>, Augmentation<Order>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public Long getDelete() {
        return this._delete;
    }

    public Long getSetup() {
        return this._setup;
    }

    public <E extends Augmentation<Order>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkDeleteRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", (Object)value);
    }

    public OrderBuilder setDelete(Long value) {
        if (value != null) {
            OrderBuilder.checkDeleteRange(value);
        }
        this._delete = value;
        return this;
    }

    private static void checkSetupRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", (Object)value);
    }

    public OrderBuilder setSetup(Long value) {
        if (value != null) {
            OrderBuilder.checkSetupRange(value);
        }
        this._setup = value;
        return this;
    }

    public OrderBuilder addAugmentation(Class<? extends Augmentation<Order>> augmentationType, Augmentation<Order> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Order>>, Augmentation<Order>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public OrderBuilder removeAugmentation(Class<? extends Augmentation<Order>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Order build() {
        return new OrderImpl(this);
    }

    private static final class OrderImpl
    implements Order {
        private final Long _delete;
        private final Long _setup;
        private Map<Class<? extends Augmentation<Order>>, Augmentation<Order>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        private OrderImpl(OrderBuilder base) {
            this._delete = base.getDelete();
            this._setup = base.getSetup();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Order> getImplementedInterface() {
            return Order.class;
        }

        @Override
        public Long getDelete() {
            return this._delete;
        }

        @Override
        public Long getSetup() {
            return this._setup;
        }

        @Override
        public <E extends Augmentation<Order>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._delete);
            result = 31 * result + Objects.hashCode(this._setup);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Order.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Order other = (Order)obj;
            if (!Objects.equals(this._delete, other.getDelete())) {
                return false;
            }
            if (!Objects.equals(this._setup, other.getSetup())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                OrderImpl otherImpl = (OrderImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Order>>, Augmentation<Order>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Order");
            CodeHelpers.appendValue(helper, "_delete", this._delete);
            CodeHelpers.appendValue(helper, "_setup", this._setup);
            CodeHelpers.appendValue(helper, "augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

