/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcep.error.object;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcep.error.object.ErrorObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcep.error.object.error.object.Tlvs;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ErrorObjectBuilder
implements Builder<ErrorObject> {
    private Tlvs _tlvs;
    private Short _type;
    private Short _value;
    private Boolean _ignore;
    private Boolean _processingRule;
    Map<Class<? extends Augmentation<ErrorObject>>, Augmentation<ErrorObject>> augmentation = Collections.emptyMap();

    public ErrorObjectBuilder() {
    }

    public ErrorObjectBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public ErrorObjectBuilder(ErrorObject base) {
        AugmentationHolder casted;
        this._tlvs = base.getTlvs();
        this._type = base.getType();
        this._value = base.getValue();
        this._ignore = base.isIgnore();
        this._processingRule = base.isProcessingRule();
        if (base instanceof ErrorObjectImpl) {
            ErrorObjectImpl impl = (ErrorObjectImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ErrorObject>>, Augmentation<ErrorObject>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader]");
    }

    public Tlvs getTlvs() {
        return this._tlvs;
    }

    public Short getType() {
        return this._type;
    }

    public Short getValue() {
        return this._value;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public <E extends Augmentation<ErrorObject>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public ErrorObjectBuilder setTlvs(Tlvs value) {
        this._tlvs = value;
        return this;
    }

    private static void checkTypeRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..255]]", (Object)value);
    }

    public ErrorObjectBuilder setType(Short value) {
        if (value != null) {
            ErrorObjectBuilder.checkTypeRange(value);
        }
        this._type = value;
        return this;
    }

    private static void checkValueRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..255]]", (Object)value);
    }

    public ErrorObjectBuilder setValue(Short value) {
        if (value != null) {
            ErrorObjectBuilder.checkValueRange(value);
        }
        this._value = value;
        return this;
    }

    public ErrorObjectBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public ErrorObjectBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public ErrorObjectBuilder addAugmentation(Class<? extends Augmentation<ErrorObject>> augmentationType, Augmentation<ErrorObject> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ErrorObject>>, Augmentation<ErrorObject>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ErrorObjectBuilder removeAugmentation(Class<? extends Augmentation<ErrorObject>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public ErrorObject build() {
        return new ErrorObjectImpl(this);
    }

    private static final class ErrorObjectImpl
    implements ErrorObject {
        private final Tlvs _tlvs;
        private final Short _type;
        private final Short _value;
        private final Boolean _ignore;
        private final Boolean _processingRule;
        private Map<Class<? extends Augmentation<ErrorObject>>, Augmentation<ErrorObject>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        private ErrorObjectImpl(ErrorObjectBuilder base) {
            this._tlvs = base.getTlvs();
            this._type = base.getType();
            this._value = base.getValue();
            this._ignore = base.isIgnore();
            this._processingRule = base.isProcessingRule();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<ErrorObject> getImplementedInterface() {
            return ErrorObject.class;
        }

        @Override
        public Tlvs getTlvs() {
            return this._tlvs;
        }

        @Override
        public Short getType() {
            return this._type;
        }

        @Override
        public Short getValue() {
            return this._value;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        @Override
        public <E extends Augmentation<ErrorObject>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._tlvs);
            result = 31 * result + Objects.hashCode(this._type);
            result = 31 * result + Objects.hashCode(this._value);
            result = 31 * result + Objects.hashCode(this._ignore);
            result = 31 * result + Objects.hashCode(this._processingRule);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ErrorObject.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ErrorObject other = (ErrorObject)obj;
            if (!Objects.equals(this._tlvs, other.getTlvs())) {
                return false;
            }
            if (!Objects.equals(this._type, other.getType())) {
                return false;
            }
            if (!Objects.equals(this._value, other.getValue())) {
                return false;
            }
            if (!Objects.equals(this._ignore, other.isIgnore())) {
                return false;
            }
            if (!Objects.equals(this._processingRule, other.isProcessingRule())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ErrorObjectImpl otherImpl = (ErrorObjectImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ErrorObject>>, Augmentation<ErrorObject>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("ErrorObject");
            CodeHelpers.appendValue(helper, "_tlvs", this._tlvs);
            CodeHelpers.appendValue(helper, "_type", this._type);
            CodeHelpers.appendValue(helper, "_value", this._value);
            CodeHelpers.appendValue(helper, "_ignore", this._ignore);
            CodeHelpers.appendValue(helper, "_processingRule", this._processingRule);
            CodeHelpers.appendValue(helper, "augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

