/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.SegmentComputation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.pcreq.message.pcreq.message.requests.segment.computation.P2p;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SegmentComputationBuilder
implements Builder<SegmentComputation> {
    private P2p _p2p;
    Map<Class<? extends Augmentation<SegmentComputation>>, Augmentation<SegmentComputation>> augmentation = Collections.emptyMap();

    public SegmentComputationBuilder() {
    }

    public SegmentComputationBuilder(SegmentComputation base) {
        AugmentationHolder casted;
        this._p2p = base.getP2p();
        if (base instanceof SegmentComputationImpl) {
            SegmentComputationImpl impl = (SegmentComputationImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<SegmentComputation>>, Augmentation<SegmentComputation>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public P2p getP2p() {
        return this._p2p;
    }

    public <E extends Augmentation<SegmentComputation>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public SegmentComputationBuilder setP2p(P2p value) {
        this._p2p = value;
        return this;
    }

    public SegmentComputationBuilder addAugmentation(Class<? extends Augmentation<SegmentComputation>> augmentationType, Augmentation<SegmentComputation> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<SegmentComputation>>, Augmentation<SegmentComputation>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public SegmentComputationBuilder removeAugmentation(Class<? extends Augmentation<SegmentComputation>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SegmentComputation build() {
        return new SegmentComputationImpl(this);
    }

    private static final class SegmentComputationImpl
    implements SegmentComputation {
        private final P2p _p2p;
        private Map<Class<? extends Augmentation<SegmentComputation>>, Augmentation<SegmentComputation>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        private SegmentComputationImpl(SegmentComputationBuilder base) {
            this._p2p = base.getP2p();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<SegmentComputation> getImplementedInterface() {
            return SegmentComputation.class;
        }

        @Override
        public P2p getP2p() {
            return this._p2p;
        }

        @Override
        public <E extends Augmentation<SegmentComputation>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._p2p);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SegmentComputation.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SegmentComputation other = (SegmentComputation)obj;
            if (!Objects.equals(this._p2p, other.getP2p())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SegmentComputationImpl otherImpl = (SegmentComputationImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<SegmentComputation>>, Augmentation<SegmentComputation>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SegmentComputation");
            CodeHelpers.appendValue(helper, "_p2p", this._p2p);
            CodeHelpers.appendValue(helper, "augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

