/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.proc.time.object.ProcTime;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ProcTimeBuilder
implements Builder<ProcTime> {
    private Long _averageProcTime;
    private Long _currentProcTime;
    private Long _maxProcTime;
    private Long _minProcTime;
    private Long _varianceProcTime;
    private Boolean _estimated;
    private Boolean _ignore;
    private Boolean _processingRule;
    Map<Class<? extends Augmentation<ProcTime>>, Augmentation<ProcTime>> augmentation = Collections.emptyMap();

    public ProcTimeBuilder() {
    }

    public ProcTimeBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public ProcTimeBuilder(ProcTime base) {
        AugmentationHolder casted;
        this._averageProcTime = base.getAverageProcTime();
        this._currentProcTime = base.getCurrentProcTime();
        this._maxProcTime = base.getMaxProcTime();
        this._minProcTime = base.getMinProcTime();
        this._varianceProcTime = base.getVarianceProcTime();
        this._estimated = base.isEstimated();
        this._ignore = base.isIgnore();
        this._processingRule = base.isProcessingRule();
        if (base instanceof ProcTimeImpl) {
            ProcTimeImpl impl = (ProcTimeImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ProcTime>>, Augmentation<ProcTime>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader]");
    }

    public Long getAverageProcTime() {
        return this._averageProcTime;
    }

    public Long getCurrentProcTime() {
        return this._currentProcTime;
    }

    public Long getMaxProcTime() {
        return this._maxProcTime;
    }

    public Long getMinProcTime() {
        return this._minProcTime;
    }

    public Long getVarianceProcTime() {
        return this._varianceProcTime;
    }

    public Boolean isEstimated() {
        return this._estimated;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public <E extends Augmentation<ProcTime>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkAverageProcTimeRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", (Object)value);
    }

    public ProcTimeBuilder setAverageProcTime(Long value) {
        if (value != null) {
            ProcTimeBuilder.checkAverageProcTimeRange(value);
        }
        this._averageProcTime = value;
        return this;
    }

    private static void checkCurrentProcTimeRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", (Object)value);
    }

    public ProcTimeBuilder setCurrentProcTime(Long value) {
        if (value != null) {
            ProcTimeBuilder.checkCurrentProcTimeRange(value);
        }
        this._currentProcTime = value;
        return this;
    }

    private static void checkMaxProcTimeRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", (Object)value);
    }

    public ProcTimeBuilder setMaxProcTime(Long value) {
        if (value != null) {
            ProcTimeBuilder.checkMaxProcTimeRange(value);
        }
        this._maxProcTime = value;
        return this;
    }

    private static void checkMinProcTimeRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", (Object)value);
    }

    public ProcTimeBuilder setMinProcTime(Long value) {
        if (value != null) {
            ProcTimeBuilder.checkMinProcTimeRange(value);
        }
        this._minProcTime = value;
        return this;
    }

    private static void checkVarianceProcTimeRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", (Object)value);
    }

    public ProcTimeBuilder setVarianceProcTime(Long value) {
        if (value != null) {
            ProcTimeBuilder.checkVarianceProcTimeRange(value);
        }
        this._varianceProcTime = value;
        return this;
    }

    public ProcTimeBuilder setEstimated(Boolean value) {
        this._estimated = value;
        return this;
    }

    public ProcTimeBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public ProcTimeBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public ProcTimeBuilder addAugmentation(Class<? extends Augmentation<ProcTime>> augmentationType, Augmentation<ProcTime> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ProcTime>>, Augmentation<ProcTime>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ProcTimeBuilder removeAugmentation(Class<? extends Augmentation<ProcTime>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public ProcTime build() {
        return new ProcTimeImpl(this);
    }

    private static final class ProcTimeImpl
    implements ProcTime {
        private final Long _averageProcTime;
        private final Long _currentProcTime;
        private final Long _maxProcTime;
        private final Long _minProcTime;
        private final Long _varianceProcTime;
        private final Boolean _estimated;
        private final Boolean _ignore;
        private final Boolean _processingRule;
        private Map<Class<? extends Augmentation<ProcTime>>, Augmentation<ProcTime>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        private ProcTimeImpl(ProcTimeBuilder base) {
            this._averageProcTime = base.getAverageProcTime();
            this._currentProcTime = base.getCurrentProcTime();
            this._maxProcTime = base.getMaxProcTime();
            this._minProcTime = base.getMinProcTime();
            this._varianceProcTime = base.getVarianceProcTime();
            this._estimated = base.isEstimated();
            this._ignore = base.isIgnore();
            this._processingRule = base.isProcessingRule();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<ProcTime> getImplementedInterface() {
            return ProcTime.class;
        }

        @Override
        public Long getAverageProcTime() {
            return this._averageProcTime;
        }

        @Override
        public Long getCurrentProcTime() {
            return this._currentProcTime;
        }

        @Override
        public Long getMaxProcTime() {
            return this._maxProcTime;
        }

        @Override
        public Long getMinProcTime() {
            return this._minProcTime;
        }

        @Override
        public Long getVarianceProcTime() {
            return this._varianceProcTime;
        }

        @Override
        public Boolean isEstimated() {
            return this._estimated;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        @Override
        public <E extends Augmentation<ProcTime>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._averageProcTime);
            result = 31 * result + Objects.hashCode(this._currentProcTime);
            result = 31 * result + Objects.hashCode(this._maxProcTime);
            result = 31 * result + Objects.hashCode(this._minProcTime);
            result = 31 * result + Objects.hashCode(this._varianceProcTime);
            result = 31 * result + Objects.hashCode(this._estimated);
            result = 31 * result + Objects.hashCode(this._ignore);
            result = 31 * result + Objects.hashCode(this._processingRule);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ProcTime.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ProcTime other = (ProcTime)obj;
            if (!Objects.equals(this._averageProcTime, other.getAverageProcTime())) {
                return false;
            }
            if (!Objects.equals(this._currentProcTime, other.getCurrentProcTime())) {
                return false;
            }
            if (!Objects.equals(this._maxProcTime, other.getMaxProcTime())) {
                return false;
            }
            if (!Objects.equals(this._minProcTime, other.getMinProcTime())) {
                return false;
            }
            if (!Objects.equals(this._varianceProcTime, other.getVarianceProcTime())) {
                return false;
            }
            if (!Objects.equals(this._estimated, other.isEstimated())) {
                return false;
            }
            if (!Objects.equals(this._ignore, other.isIgnore())) {
                return false;
            }
            if (!Objects.equals(this._processingRule, other.isProcessingRule())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ProcTimeImpl otherImpl = (ProcTimeImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ProcTime>>, Augmentation<ProcTime>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("ProcTime");
            CodeHelpers.appendValue(helper, "_averageProcTime", this._averageProcTime);
            CodeHelpers.appendValue(helper, "_currentProcTime", this._currentProcTime);
            CodeHelpers.appendValue(helper, "_maxProcTime", this._maxProcTime);
            CodeHelpers.appendValue(helper, "_minProcTime", this._minProcTime);
            CodeHelpers.appendValue(helper, "_varianceProcTime", this._varianceProcTime);
            CodeHelpers.appendValue(helper, "_estimated", this._estimated);
            CodeHelpers.appendValue(helper, "_ignore", this._ignore);
            CodeHelpers.appendValue(helper, "_processingRule", this._processingRule);
            CodeHelpers.appendValue(helper, "augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

