/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.reoptimization.bandwidth.object;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.reoptimization.bandwidth.object.ReoptimizationBandwidth;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ReoptimizationBandwidthBuilder
implements Builder<ReoptimizationBandwidth> {
    private org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth _bandwidth;
    private Boolean _ignore;
    private Boolean _processingRule;
    Map<Class<? extends Augmentation<ReoptimizationBandwidth>>, Augmentation<ReoptimizationBandwidth>> augmentation = Collections.emptyMap();

    public ReoptimizationBandwidthBuilder() {
    }

    public ReoptimizationBandwidthBuilder(Bandwidth arg) {
        this._bandwidth = arg.getBandwidth();
    }

    public ReoptimizationBandwidthBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public ReoptimizationBandwidthBuilder(ReoptimizationBandwidth base) {
        AugmentationHolder casted;
        this._bandwidth = base.getBandwidth();
        this._ignore = base.isIgnore();
        this._processingRule = base.isProcessingRule();
        if (base instanceof ReoptimizationBandwidthImpl) {
            ReoptimizationBandwidthImpl impl = (ReoptimizationBandwidthImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ReoptimizationBandwidth>>, Augmentation<ReoptimizationBandwidth>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof Bandwidth) {
            this._bandwidth = ((Bandwidth)arg).getBandwidth();
            isValidArg = true;
        }
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.Bandwidth, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader]");
    }

    public org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth getBandwidth() {
        return this._bandwidth;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public <E extends Augmentation<ReoptimizationBandwidth>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public ReoptimizationBandwidthBuilder setBandwidth(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth value) {
        this._bandwidth = value;
        return this;
    }

    public ReoptimizationBandwidthBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public ReoptimizationBandwidthBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public ReoptimizationBandwidthBuilder addAugmentation(Class<? extends Augmentation<ReoptimizationBandwidth>> augmentationType, Augmentation<ReoptimizationBandwidth> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ReoptimizationBandwidth>>, Augmentation<ReoptimizationBandwidth>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ReoptimizationBandwidthBuilder removeAugmentation(Class<? extends Augmentation<ReoptimizationBandwidth>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public ReoptimizationBandwidth build() {
        return new ReoptimizationBandwidthImpl(this);
    }

    private static final class ReoptimizationBandwidthImpl
    implements ReoptimizationBandwidth {
        private final org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth _bandwidth;
        private final Boolean _ignore;
        private final Boolean _processingRule;
        private Map<Class<? extends Augmentation<ReoptimizationBandwidth>>, Augmentation<ReoptimizationBandwidth>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        private ReoptimizationBandwidthImpl(ReoptimizationBandwidthBuilder base) {
            this._bandwidth = base.getBandwidth();
            this._ignore = base.isIgnore();
            this._processingRule = base.isProcessingRule();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<ReoptimizationBandwidth> getImplementedInterface() {
            return ReoptimizationBandwidth.class;
        }

        @Override
        public org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth getBandwidth() {
            return this._bandwidth;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        @Override
        public <E extends Augmentation<ReoptimizationBandwidth>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._bandwidth);
            result = 31 * result + Objects.hashCode(this._ignore);
            result = 31 * result + Objects.hashCode(this._processingRule);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ReoptimizationBandwidth.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ReoptimizationBandwidth other = (ReoptimizationBandwidth)obj;
            if (!Objects.equals(this._bandwidth, other.getBandwidth())) {
                return false;
            }
            if (!Objects.equals(this._ignore, other.isIgnore())) {
                return false;
            }
            if (!Objects.equals(this._processingRule, other.isProcessingRule())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ReoptimizationBandwidthImpl otherImpl = (ReoptimizationBandwidthImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ReoptimizationBandwidth>>, Augmentation<ReoptimizationBandwidth>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("ReoptimizationBandwidth");
            CodeHelpers.appendValue(helper, "_bandwidth", this._bandwidth);
            CodeHelpers.appendValue(helper, "_ignore", this._ignore);
            CodeHelpers.appendValue(helper, "_processingRule", this._processingRule);
            CodeHelpers.appendValue(helper, "augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

