/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.RequestId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.Rp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.rp.Tlvs;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class RpBuilder
implements Builder<Rp> {
    private Short _priority;
    private RequestId _requestId;
    private Tlvs _tlvs;
    private Boolean _biDirectional;
    private Boolean _eroCompression;
    private Boolean _fragmentation;
    private Boolean _ignore;
    private Boolean _loose;
    private Boolean _makeBeforeBreak;
    private Boolean _order;
    private Boolean _p2mp;
    private Boolean _pathKey;
    private Boolean _processingRule;
    private Boolean _reoptimization;
    private Boolean _supplyOf;
    Map<Class<? extends Augmentation<Rp>>, Augmentation<Rp>> augmentation = Collections.emptyMap();

    public RpBuilder() {
    }

    public RpBuilder(ObjectHeader arg) {
        this._processingRule = arg.isProcessingRule();
        this._ignore = arg.isIgnore();
    }

    public RpBuilder(Rp base) {
        AugmentationHolder casted;
        this._priority = base.getPriority();
        this._requestId = base.getRequestId();
        this._tlvs = base.getTlvs();
        this._biDirectional = base.isBiDirectional();
        this._eroCompression = base.isEroCompression();
        this._fragmentation = base.isFragmentation();
        this._ignore = base.isIgnore();
        this._loose = base.isLoose();
        this._makeBeforeBreak = base.isMakeBeforeBreak();
        this._order = base.isOrder();
        this._p2mp = base.isP2mp();
        this._pathKey = base.isPathKey();
        this._processingRule = base.isProcessingRule();
        this._reoptimization = base.isReoptimization();
        this._supplyOf = base.isSupplyOf();
        if (base instanceof RpImpl) {
            RpImpl impl = (RpImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Rp>>, Augmentation<Rp>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof ObjectHeader) {
            this._processingRule = ((ObjectHeader)arg).isProcessingRule();
            this._ignore = ((ObjectHeader)arg).isIgnore();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ObjectHeader]");
    }

    public Short getPriority() {
        return this._priority;
    }

    public RequestId getRequestId() {
        return this._requestId;
    }

    public Tlvs getTlvs() {
        return this._tlvs;
    }

    public Boolean isBiDirectional() {
        return this._biDirectional;
    }

    public Boolean isEroCompression() {
        return this._eroCompression;
    }

    public Boolean isFragmentation() {
        return this._fragmentation;
    }

    public Boolean isIgnore() {
        return this._ignore;
    }

    public Boolean isLoose() {
        return this._loose;
    }

    public Boolean isMakeBeforeBreak() {
        return this._makeBeforeBreak;
    }

    public Boolean isOrder() {
        return this._order;
    }

    public Boolean isP2mp() {
        return this._p2mp;
    }

    public Boolean isPathKey() {
        return this._pathKey;
    }

    public Boolean isProcessingRule() {
        return this._processingRule;
    }

    public Boolean isReoptimization() {
        return this._reoptimization;
    }

    public Boolean isSupplyOf() {
        return this._supplyOf;
    }

    public <E extends Augmentation<Rp>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkPriorityRange(short value) {
        if (value >= 1 && value <= 7) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[1..7]]", (Object)value);
    }

    public RpBuilder setPriority(Short value) {
        if (value != null) {
            RpBuilder.checkPriorityRange(value);
        }
        this._priority = value;
        return this;
    }

    public RpBuilder setRequestId(RequestId value) {
        this._requestId = value;
        return this;
    }

    public RpBuilder setTlvs(Tlvs value) {
        this._tlvs = value;
        return this;
    }

    public RpBuilder setBiDirectional(Boolean value) {
        this._biDirectional = value;
        return this;
    }

    public RpBuilder setEroCompression(Boolean value) {
        this._eroCompression = value;
        return this;
    }

    public RpBuilder setFragmentation(Boolean value) {
        this._fragmentation = value;
        return this;
    }

    public RpBuilder setIgnore(Boolean value) {
        this._ignore = value;
        return this;
    }

    public RpBuilder setLoose(Boolean value) {
        this._loose = value;
        return this;
    }

    public RpBuilder setMakeBeforeBreak(Boolean value) {
        this._makeBeforeBreak = value;
        return this;
    }

    public RpBuilder setOrder(Boolean value) {
        this._order = value;
        return this;
    }

    public RpBuilder setP2mp(Boolean value) {
        this._p2mp = value;
        return this;
    }

    public RpBuilder setPathKey(Boolean value) {
        this._pathKey = value;
        return this;
    }

    public RpBuilder setProcessingRule(Boolean value) {
        this._processingRule = value;
        return this;
    }

    public RpBuilder setReoptimization(Boolean value) {
        this._reoptimization = value;
        return this;
    }

    public RpBuilder setSupplyOf(Boolean value) {
        this._supplyOf = value;
        return this;
    }

    public RpBuilder addAugmentation(Class<? extends Augmentation<Rp>> augmentationType, Augmentation<Rp> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Rp>>, Augmentation<Rp>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public RpBuilder removeAugmentation(Class<? extends Augmentation<Rp>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Rp build() {
        return new RpImpl(this);
    }

    private static final class RpImpl
    implements Rp {
        private final Short _priority;
        private final RequestId _requestId;
        private final Tlvs _tlvs;
        private final Boolean _biDirectional;
        private final Boolean _eroCompression;
        private final Boolean _fragmentation;
        private final Boolean _ignore;
        private final Boolean _loose;
        private final Boolean _makeBeforeBreak;
        private final Boolean _order;
        private final Boolean _p2mp;
        private final Boolean _pathKey;
        private final Boolean _processingRule;
        private final Boolean _reoptimization;
        private final Boolean _supplyOf;
        private Map<Class<? extends Augmentation<Rp>>, Augmentation<Rp>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        private RpImpl(RpBuilder base) {
            this._priority = base.getPriority();
            this._requestId = base.getRequestId();
            this._tlvs = base.getTlvs();
            this._biDirectional = base.isBiDirectional();
            this._eroCompression = base.isEroCompression();
            this._fragmentation = base.isFragmentation();
            this._ignore = base.isIgnore();
            this._loose = base.isLoose();
            this._makeBeforeBreak = base.isMakeBeforeBreak();
            this._order = base.isOrder();
            this._p2mp = base.isP2mp();
            this._pathKey = base.isPathKey();
            this._processingRule = base.isProcessingRule();
            this._reoptimization = base.isReoptimization();
            this._supplyOf = base.isSupplyOf();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Rp> getImplementedInterface() {
            return Rp.class;
        }

        @Override
        public Short getPriority() {
            return this._priority;
        }

        @Override
        public RequestId getRequestId() {
            return this._requestId;
        }

        @Override
        public Tlvs getTlvs() {
            return this._tlvs;
        }

        @Override
        public Boolean isBiDirectional() {
            return this._biDirectional;
        }

        @Override
        public Boolean isEroCompression() {
            return this._eroCompression;
        }

        @Override
        public Boolean isFragmentation() {
            return this._fragmentation;
        }

        @Override
        public Boolean isIgnore() {
            return this._ignore;
        }

        @Override
        public Boolean isLoose() {
            return this._loose;
        }

        @Override
        public Boolean isMakeBeforeBreak() {
            return this._makeBeforeBreak;
        }

        @Override
        public Boolean isOrder() {
            return this._order;
        }

        @Override
        public Boolean isP2mp() {
            return this._p2mp;
        }

        @Override
        public Boolean isPathKey() {
            return this._pathKey;
        }

        @Override
        public Boolean isProcessingRule() {
            return this._processingRule;
        }

        @Override
        public Boolean isReoptimization() {
            return this._reoptimization;
        }

        @Override
        public Boolean isSupplyOf() {
            return this._supplyOf;
        }

        @Override
        public <E extends Augmentation<Rp>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._priority);
            result = 31 * result + Objects.hashCode(this._requestId);
            result = 31 * result + Objects.hashCode(this._tlvs);
            result = 31 * result + Objects.hashCode(this._biDirectional);
            result = 31 * result + Objects.hashCode(this._eroCompression);
            result = 31 * result + Objects.hashCode(this._fragmentation);
            result = 31 * result + Objects.hashCode(this._ignore);
            result = 31 * result + Objects.hashCode(this._loose);
            result = 31 * result + Objects.hashCode(this._makeBeforeBreak);
            result = 31 * result + Objects.hashCode(this._order);
            result = 31 * result + Objects.hashCode(this._p2mp);
            result = 31 * result + Objects.hashCode(this._pathKey);
            result = 31 * result + Objects.hashCode(this._processingRule);
            result = 31 * result + Objects.hashCode(this._reoptimization);
            result = 31 * result + Objects.hashCode(this._supplyOf);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Rp.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Rp other = (Rp)obj;
            if (!Objects.equals(this._priority, other.getPriority())) {
                return false;
            }
            if (!Objects.equals(this._requestId, other.getRequestId())) {
                return false;
            }
            if (!Objects.equals(this._tlvs, other.getTlvs())) {
                return false;
            }
            if (!Objects.equals(this._biDirectional, other.isBiDirectional())) {
                return false;
            }
            if (!Objects.equals(this._eroCompression, other.isEroCompression())) {
                return false;
            }
            if (!Objects.equals(this._fragmentation, other.isFragmentation())) {
                return false;
            }
            if (!Objects.equals(this._ignore, other.isIgnore())) {
                return false;
            }
            if (!Objects.equals(this._loose, other.isLoose())) {
                return false;
            }
            if (!Objects.equals(this._makeBeforeBreak, other.isMakeBeforeBreak())) {
                return false;
            }
            if (!Objects.equals(this._order, other.isOrder())) {
                return false;
            }
            if (!Objects.equals(this._p2mp, other.isP2mp())) {
                return false;
            }
            if (!Objects.equals(this._pathKey, other.isPathKey())) {
                return false;
            }
            if (!Objects.equals(this._processingRule, other.isProcessingRule())) {
                return false;
            }
            if (!Objects.equals(this._reoptimization, other.isReoptimization())) {
                return false;
            }
            if (!Objects.equals(this._supplyOf, other.isSupplyOf())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                RpImpl otherImpl = (RpImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Rp>>, Augmentation<Rp>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Rp");
            CodeHelpers.appendValue(helper, "_priority", this._priority);
            CodeHelpers.appendValue(helper, "_requestId", this._requestId);
            CodeHelpers.appendValue(helper, "_tlvs", this._tlvs);
            CodeHelpers.appendValue(helper, "_biDirectional", this._biDirectional);
            CodeHelpers.appendValue(helper, "_eroCompression", this._eroCompression);
            CodeHelpers.appendValue(helper, "_fragmentation", this._fragmentation);
            CodeHelpers.appendValue(helper, "_ignore", this._ignore);
            CodeHelpers.appendValue(helper, "_loose", this._loose);
            CodeHelpers.appendValue(helper, "_makeBeforeBreak", this._makeBeforeBreak);
            CodeHelpers.appendValue(helper, "_order", this._order);
            CodeHelpers.appendValue(helper, "_p2mp", this._p2mp);
            CodeHelpers.appendValue(helper, "_pathKey", this._pathKey);
            CodeHelpers.appendValue(helper, "_processingRule", this._processingRule);
            CodeHelpers.appendValue(helper, "_reoptimization", this._reoptimization);
            CodeHelpers.appendValue(helper, "_supplyOf", this._supplyOf);
            CodeHelpers.appendValue(helper, "augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

