/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.rp;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OrderTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.PathSetupTypeTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformationTlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.order.tlv.Order;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.path.setup.type.tlv.PathSetupType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.rp.object.rp.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vendor.information.tlvs.VendorInformationTlv;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TlvsBuilder
implements Builder<Tlvs> {
    private Order _order;
    private PathSetupType _pathSetupType;
    private List<VendorInformationTlv> _vendorInformationTlv;
    Map<Class<? extends Augmentation<Tlvs>>, Augmentation<Tlvs>> augmentation = Collections.emptyMap();

    public TlvsBuilder() {
    }

    public TlvsBuilder(VendorInformationTlvs arg) {
        this._vendorInformationTlv = arg.getVendorInformationTlv();
    }

    public TlvsBuilder(OrderTlv arg) {
        this._order = arg.getOrder();
    }

    public TlvsBuilder(PathSetupTypeTlv arg) {
        this._pathSetupType = arg.getPathSetupType();
    }

    public TlvsBuilder(Tlvs base) {
        AugmentationHolder casted;
        this._order = base.getOrder();
        this._pathSetupType = base.getPathSetupType();
        this._vendorInformationTlv = base.getVendorInformationTlv();
        if (base instanceof TlvsImpl) {
            TlvsImpl impl = (TlvsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Tlvs>>, Augmentation<Tlvs>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof OrderTlv) {
            this._order = ((OrderTlv)arg).getOrder();
            isValidArg = true;
        }
        if (arg instanceof PathSetupTypeTlv) {
            this._pathSetupType = ((PathSetupTypeTlv)arg).getPathSetupType();
            isValidArg = true;
        }
        if (arg instanceof VendorInformationTlvs) {
            this._vendorInformationTlv = ((VendorInformationTlvs)arg).getVendorInformationTlv();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.OrderTlv, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.PathSetupTypeTlv, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.VendorInformationTlvs]");
    }

    public Order getOrder() {
        return this._order;
    }

    public PathSetupType getPathSetupType() {
        return this._pathSetupType;
    }

    public List<VendorInformationTlv> getVendorInformationTlv() {
        return this._vendorInformationTlv;
    }

    public <E extends Augmentation<Tlvs>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public TlvsBuilder setOrder(Order value) {
        this._order = value;
        return this;
    }

    public TlvsBuilder setPathSetupType(PathSetupType value) {
        this._pathSetupType = value;
        return this;
    }

    public TlvsBuilder setVendorInformationTlv(List<VendorInformationTlv> values) {
        this._vendorInformationTlv = values;
        return this;
    }

    public TlvsBuilder addAugmentation(Class<? extends Augmentation<Tlvs>> augmentationType, Augmentation<Tlvs> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Tlvs>>, Augmentation<Tlvs>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public TlvsBuilder removeAugmentation(Class<? extends Augmentation<Tlvs>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public Tlvs build() {
        return new TlvsImpl(this);
    }

    private static final class TlvsImpl
    implements Tlvs {
        private final Order _order;
        private final PathSetupType _pathSetupType;
        private final List<VendorInformationTlv> _vendorInformationTlv;
        private Map<Class<? extends Augmentation<Tlvs>>, Augmentation<Tlvs>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        private TlvsImpl(TlvsBuilder base) {
            this._order = base.getOrder();
            this._pathSetupType = base.getPathSetupType();
            this._vendorInformationTlv = base.getVendorInformationTlv();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<Tlvs> getImplementedInterface() {
            return Tlvs.class;
        }

        @Override
        public Order getOrder() {
            return this._order;
        }

        @Override
        public PathSetupType getPathSetupType() {
            return this._pathSetupType;
        }

        @Override
        public List<VendorInformationTlv> getVendorInformationTlv() {
            return this._vendorInformationTlv;
        }

        @Override
        public <E extends Augmentation<Tlvs>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._order);
            result = 31 * result + Objects.hashCode(this._pathSetupType);
            result = 31 * result + Objects.hashCode(this._vendorInformationTlv);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Tlvs.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Tlvs other = (Tlvs)obj;
            if (!Objects.equals(this._order, other.getOrder())) {
                return false;
            }
            if (!Objects.equals(this._pathSetupType, other.getPathSetupType())) {
                return false;
            }
            if (!Objects.equals(this._vendorInformationTlv, other.getVendorInformationTlv())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TlvsImpl otherImpl = (TlvsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Tlvs>>, Augmentation<Tlvs>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Tlvs");
            CodeHelpers.appendValue(helper, "_order", this._order);
            CodeHelpers.appendValue(helper, "_pathSetupType", this._pathSetupType);
            CodeHelpers.appendValue(helper, "_vendorInformationTlv", this._vendorInformationTlv);
            CodeHelpers.appendValue(helper, "augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

