/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vs.tlv;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.iana.rev130816.EnterpriseNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vs.tlv.VsTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.vs.tlv.vs.tlv.VendorPayload;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class VsTlvBuilder
implements Builder<VsTlv> {
    private EnterpriseNumber _enterpriseNumber;
    private VendorPayload _vendorPayload;
    Map<Class<? extends Augmentation<VsTlv>>, Augmentation<VsTlv>> augmentation = Collections.emptyMap();

    public VsTlvBuilder() {
    }

    public VsTlvBuilder(VsTlv base) {
        AugmentationHolder casted;
        this._enterpriseNumber = base.getEnterpriseNumber();
        this._vendorPayload = base.getVendorPayload();
        if (base instanceof VsTlvImpl) {
            VsTlvImpl impl = (VsTlvImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<VsTlv>>, Augmentation<VsTlv>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public EnterpriseNumber getEnterpriseNumber() {
        return this._enterpriseNumber;
    }

    public VendorPayload getVendorPayload() {
        return this._vendorPayload;
    }

    public <E extends Augmentation<VsTlv>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public VsTlvBuilder setEnterpriseNumber(EnterpriseNumber value) {
        this._enterpriseNumber = value;
        return this;
    }

    public VsTlvBuilder setVendorPayload(VendorPayload value) {
        this._vendorPayload = value;
        return this;
    }

    public VsTlvBuilder addAugmentation(Class<? extends Augmentation<VsTlv>> augmentationType, Augmentation<VsTlv> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<VsTlv>>, Augmentation<VsTlv>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public VsTlvBuilder removeAugmentation(Class<? extends Augmentation<VsTlv>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public VsTlv build() {
        return new VsTlvImpl(this);
    }

    private static final class VsTlvImpl
    implements VsTlv {
        private final EnterpriseNumber _enterpriseNumber;
        private final VendorPayload _vendorPayload;
        private Map<Class<? extends Augmentation<VsTlv>>, Augmentation<VsTlv>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        private VsTlvImpl(VsTlvBuilder base) {
            this._enterpriseNumber = base.getEnterpriseNumber();
            this._vendorPayload = base.getVendorPayload();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<VsTlv> getImplementedInterface() {
            return VsTlv.class;
        }

        @Override
        public EnterpriseNumber getEnterpriseNumber() {
            return this._enterpriseNumber;
        }

        @Override
        public VendorPayload getVendorPayload() {
            return this._vendorPayload;
        }

        @Override
        public <E extends Augmentation<VsTlv>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._enterpriseNumber);
            result = 31 * result + Objects.hashCode(this._vendorPayload);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!VsTlv.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            VsTlv other = (VsTlv)obj;
            if (!Objects.equals(this._enterpriseNumber, other.getEnterpriseNumber())) {
                return false;
            }
            if (!Objects.equals(this._vendorPayload, other.getVendorPayload())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                VsTlvImpl otherImpl = (VsTlvImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<VsTlv>>, Augmentation<VsTlv>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("VsTlv");
            CodeHelpers.appendValue(helper, "_enterpriseNumber", this._enterpriseNumber);
            CodeHelpers.appendValue(helper, "_vendorPayload", this._vendorPayload);
            CodeHelpers.appendValue(helper, "augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

