/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820;

import com.google.common.base.MoreObjects;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.util.Objects;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;

public class PathKey
implements Serializable {
    private static final long serialVersionUID = 1330045814905353022L;
    private final Integer _value;

    private static void check_valueRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..65535]]", (Object)value);
    }

    @ConstructorProperties(value={"value"})
    public PathKey(Integer _value) {
        if (_value != null) {
            PathKey.check_valueRange(_value);
        }
        Objects.requireNonNull(_value, "Supplied value may not be null");
        this._value = _value;
    }

    public PathKey(PathKey source) {
        this._value = source._value;
    }

    public static PathKey getDefaultInstance(String defaultValue) {
        return new PathKey(Integer.valueOf(defaultValue));
    }

    public Integer getValue() {
        return this._value;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Objects.hashCode(this._value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PathKey other = (PathKey)obj;
        return Objects.equals(this._value, other._value);
    }

    public String toString() {
        MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(PathKey.class);
        CodeHelpers.appendValue(helper, "_value", this._value);
        return helper.toString();
    }
}

