/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.label.type.waveband.switching.label._case;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.label.type.waveband.switching.label._case.WavebandSwitchingLabel;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class WavebandSwitchingLabelBuilder
implements Builder<WavebandSwitchingLabel> {
    private Long _endLabel;
    private Long _startLabel;
    private Long _wavebandId;
    Map<Class<? extends Augmentation<WavebandSwitchingLabel>>, Augmentation<WavebandSwitchingLabel>> augmentation = Collections.emptyMap();

    public WavebandSwitchingLabelBuilder() {
    }

    public WavebandSwitchingLabelBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.WavebandSwitchingLabel arg) {
        this._endLabel = arg.getEndLabel();
        this._startLabel = arg.getStartLabel();
        this._wavebandId = arg.getWavebandId();
    }

    public WavebandSwitchingLabelBuilder(WavebandSwitchingLabel base) {
        AugmentationHolder casted;
        this._endLabel = base.getEndLabel();
        this._startLabel = base.getStartLabel();
        this._wavebandId = base.getWavebandId();
        if (base instanceof WavebandSwitchingLabelImpl) {
            WavebandSwitchingLabelImpl impl = (WavebandSwitchingLabelImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<WavebandSwitchingLabel>>, Augmentation<WavebandSwitchingLabel>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.WavebandSwitchingLabel) {
            this._endLabel = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.WavebandSwitchingLabel)arg).getEndLabel();
            this._startLabel = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.WavebandSwitchingLabel)arg).getStartLabel();
            this._wavebandId = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.WavebandSwitchingLabel)arg).getWavebandId();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.WavebandSwitchingLabel]");
    }

    public Long getEndLabel() {
        return this._endLabel;
    }

    public Long getStartLabel() {
        return this._startLabel;
    }

    public Long getWavebandId() {
        return this._wavebandId;
    }

    public <E extends Augmentation<WavebandSwitchingLabel>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkEndLabelRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", (Object)value);
    }

    public WavebandSwitchingLabelBuilder setEndLabel(Long value) {
        if (value != null) {
            WavebandSwitchingLabelBuilder.checkEndLabelRange(value);
        }
        this._endLabel = value;
        return this;
    }

    private static void checkStartLabelRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", (Object)value);
    }

    public WavebandSwitchingLabelBuilder setStartLabel(Long value) {
        if (value != null) {
            WavebandSwitchingLabelBuilder.checkStartLabelRange(value);
        }
        this._startLabel = value;
        return this;
    }

    private static void checkWavebandIdRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", (Object)value);
    }

    public WavebandSwitchingLabelBuilder setWavebandId(Long value) {
        if (value != null) {
            WavebandSwitchingLabelBuilder.checkWavebandIdRange(value);
        }
        this._wavebandId = value;
        return this;
    }

    public WavebandSwitchingLabelBuilder addAugmentation(Class<? extends Augmentation<WavebandSwitchingLabel>> augmentationType, Augmentation<WavebandSwitchingLabel> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<WavebandSwitchingLabel>>, Augmentation<WavebandSwitchingLabel>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public WavebandSwitchingLabelBuilder removeAugmentation(Class<? extends Augmentation<WavebandSwitchingLabel>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public WavebandSwitchingLabel build() {
        return new WavebandSwitchingLabelImpl(this);
    }

    private static final class WavebandSwitchingLabelImpl
    implements WavebandSwitchingLabel {
        private final Long _endLabel;
        private final Long _startLabel;
        private final Long _wavebandId;
        private Map<Class<? extends Augmentation<WavebandSwitchingLabel>>, Augmentation<WavebandSwitchingLabel>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        private WavebandSwitchingLabelImpl(WavebandSwitchingLabelBuilder base) {
            this._endLabel = base.getEndLabel();
            this._startLabel = base.getStartLabel();
            this._wavebandId = base.getWavebandId();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<WavebandSwitchingLabel> getImplementedInterface() {
            return WavebandSwitchingLabel.class;
        }

        @Override
        public Long getEndLabel() {
            return this._endLabel;
        }

        @Override
        public Long getStartLabel() {
            return this._startLabel;
        }

        @Override
        public Long getWavebandId() {
            return this._wavebandId;
        }

        @Override
        public <E extends Augmentation<WavebandSwitchingLabel>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._endLabel);
            result = 31 * result + Objects.hashCode(this._startLabel);
            result = 31 * result + Objects.hashCode(this._wavebandId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!WavebandSwitchingLabel.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            WavebandSwitchingLabel other = (WavebandSwitchingLabel)obj;
            if (!Objects.equals(this._endLabel, other.getEndLabel())) {
                return false;
            }
            if (!Objects.equals(this._startLabel, other.getStartLabel())) {
                return false;
            }
            if (!Objects.equals(this._wavebandId, other.getWavebandId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                WavebandSwitchingLabelImpl otherImpl = (WavebandSwitchingLabelImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<WavebandSwitchingLabel>>, Augmentation<WavebandSwitchingLabel>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("WavebandSwitchingLabel");
            CodeHelpers.appendValue(helper, "_endLabel", this._endLabel);
            CodeHelpers.appendValue(helper, "_startLabel", this._startLabel);
            CodeHelpers.appendValue(helper, "_wavebandId", this._wavebandId);
            CodeHelpers.appendValue(helper, "augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

