/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.protection.subobject;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.LinkFlags;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.LspFlag;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.protection.subobject.ProtectionSubobject;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ProtectionSubobjectBuilder
implements Builder<ProtectionSubobject> {
    private LinkFlags _linkFlags;
    private LspFlag _lspFlag;
    private LspFlag _segFlag;
    private Boolean _inPlace;
    private Boolean _notification;
    private Boolean _operational;
    private Boolean _protecting;
    private Boolean _required;
    private Boolean _secondary;
    Map<Class<? extends Augmentation<ProtectionSubobject>>, Augmentation<ProtectionSubobject>> augmentation = Collections.emptyMap();

    public ProtectionSubobjectBuilder() {
    }

    public ProtectionSubobjectBuilder(ProtectionSubobject base) {
        AugmentationHolder casted;
        this._linkFlags = base.getLinkFlags();
        this._lspFlag = base.getLspFlag();
        this._segFlag = base.getSegFlag();
        this._inPlace = base.isInPlace();
        this._notification = base.isNotification();
        this._operational = base.isOperational();
        this._protecting = base.isProtecting();
        this._required = base.isRequired();
        this._secondary = base.isSecondary();
        if (base instanceof ProtectionSubobjectImpl) {
            ProtectionSubobjectImpl impl = (ProtectionSubobjectImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ProtectionSubobject>>, Augmentation<ProtectionSubobject>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public LinkFlags getLinkFlags() {
        return this._linkFlags;
    }

    public LspFlag getLspFlag() {
        return this._lspFlag;
    }

    public LspFlag getSegFlag() {
        return this._segFlag;
    }

    public Boolean isInPlace() {
        return this._inPlace;
    }

    public Boolean isNotification() {
        return this._notification;
    }

    public Boolean isOperational() {
        return this._operational;
    }

    public Boolean isProtecting() {
        return this._protecting;
    }

    public Boolean isRequired() {
        return this._required;
    }

    public Boolean isSecondary() {
        return this._secondary;
    }

    public <E extends Augmentation<ProtectionSubobject>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public ProtectionSubobjectBuilder setLinkFlags(LinkFlags value) {
        this._linkFlags = value;
        return this;
    }

    public ProtectionSubobjectBuilder setLspFlag(LspFlag value) {
        this._lspFlag = value;
        return this;
    }

    public ProtectionSubobjectBuilder setSegFlag(LspFlag value) {
        this._segFlag = value;
        return this;
    }

    public ProtectionSubobjectBuilder setInPlace(Boolean value) {
        this._inPlace = value;
        return this;
    }

    public ProtectionSubobjectBuilder setNotification(Boolean value) {
        this._notification = value;
        return this;
    }

    public ProtectionSubobjectBuilder setOperational(Boolean value) {
        this._operational = value;
        return this;
    }

    public ProtectionSubobjectBuilder setProtecting(Boolean value) {
        this._protecting = value;
        return this;
    }

    public ProtectionSubobjectBuilder setRequired(Boolean value) {
        this._required = value;
        return this;
    }

    public ProtectionSubobjectBuilder setSecondary(Boolean value) {
        this._secondary = value;
        return this;
    }

    public ProtectionSubobjectBuilder addAugmentation(Class<? extends Augmentation<ProtectionSubobject>> augmentationType, Augmentation<ProtectionSubobject> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ProtectionSubobject>>, Augmentation<ProtectionSubobject>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ProtectionSubobjectBuilder removeAugmentation(Class<? extends Augmentation<ProtectionSubobject>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public ProtectionSubobject build() {
        return new ProtectionSubobjectImpl(this);
    }

    private static final class ProtectionSubobjectImpl
    implements ProtectionSubobject {
        private final LinkFlags _linkFlags;
        private final LspFlag _lspFlag;
        private final LspFlag _segFlag;
        private final Boolean _inPlace;
        private final Boolean _notification;
        private final Boolean _operational;
        private final Boolean _protecting;
        private final Boolean _required;
        private final Boolean _secondary;
        private Map<Class<? extends Augmentation<ProtectionSubobject>>, Augmentation<ProtectionSubobject>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        private ProtectionSubobjectImpl(ProtectionSubobjectBuilder base) {
            this._linkFlags = base.getLinkFlags();
            this._lspFlag = base.getLspFlag();
            this._segFlag = base.getSegFlag();
            this._inPlace = base.isInPlace();
            this._notification = base.isNotification();
            this._operational = base.isOperational();
            this._protecting = base.isProtecting();
            this._required = base.isRequired();
            this._secondary = base.isSecondary();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<ProtectionSubobject> getImplementedInterface() {
            return ProtectionSubobject.class;
        }

        @Override
        public LinkFlags getLinkFlags() {
            return this._linkFlags;
        }

        @Override
        public LspFlag getLspFlag() {
            return this._lspFlag;
        }

        @Override
        public LspFlag getSegFlag() {
            return this._segFlag;
        }

        @Override
        public Boolean isInPlace() {
            return this._inPlace;
        }

        @Override
        public Boolean isNotification() {
            return this._notification;
        }

        @Override
        public Boolean isOperational() {
            return this._operational;
        }

        @Override
        public Boolean isProtecting() {
            return this._protecting;
        }

        @Override
        public Boolean isRequired() {
            return this._required;
        }

        @Override
        public Boolean isSecondary() {
            return this._secondary;
        }

        @Override
        public <E extends Augmentation<ProtectionSubobject>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._linkFlags);
            result = 31 * result + Objects.hashCode(this._lspFlag);
            result = 31 * result + Objects.hashCode(this._segFlag);
            result = 31 * result + Objects.hashCode(this._inPlace);
            result = 31 * result + Objects.hashCode(this._notification);
            result = 31 * result + Objects.hashCode(this._operational);
            result = 31 * result + Objects.hashCode(this._protecting);
            result = 31 * result + Objects.hashCode(this._required);
            result = 31 * result + Objects.hashCode(this._secondary);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ProtectionSubobject.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ProtectionSubobject other = (ProtectionSubobject)obj;
            if (!Objects.equals(this._linkFlags, other.getLinkFlags())) {
                return false;
            }
            if (!Objects.equals(this._lspFlag, other.getLspFlag())) {
                return false;
            }
            if (!Objects.equals(this._segFlag, other.getSegFlag())) {
                return false;
            }
            if (!Objects.equals(this._inPlace, other.isInPlace())) {
                return false;
            }
            if (!Objects.equals(this._notification, other.isNotification())) {
                return false;
            }
            if (!Objects.equals(this._operational, other.isOperational())) {
                return false;
            }
            if (!Objects.equals(this._protecting, other.isProtecting())) {
                return false;
            }
            if (!Objects.equals(this._required, other.isRequired())) {
                return false;
            }
            if (!Objects.equals(this._secondary, other.isSecondary())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ProtectionSubobjectImpl otherImpl = (ProtectionSubobjectImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ProtectionSubobject>>, Augmentation<ProtectionSubobject>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("ProtectionSubobject");
            CodeHelpers.appendValue(helper, "_linkFlags", this._linkFlags);
            CodeHelpers.appendValue(helper, "_lspFlag", this._lspFlag);
            CodeHelpers.appendValue(helper, "_segFlag", this._segFlag);
            CodeHelpers.appendValue(helper, "_inPlace", this._inPlace);
            CodeHelpers.appendValue(helper, "_notification", this._notification);
            CodeHelpers.appendValue(helper, "_operational", this._operational);
            CodeHelpers.appendValue(helper, "_protecting", this._protecting);
            CodeHelpers.appendValue(helper, "_required", this._required);
            CodeHelpers.appendValue(helper, "_secondary", this._secondary);
            CodeHelpers.appendValue(helper, "augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

