/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.tspec.object;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ieee754.rev130819.Float32;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.tspec.object.TspecObject;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class TspecObjectBuilder
implements Builder<TspecObject> {
    private Long _maximumPacketSize;
    private Long _minimumPolicedUnit;
    private Float32 _peakDataRate;
    private Float32 _tokenBucketRate;
    private Float32 _tokenBucketSize;
    Map<Class<? extends Augmentation<TspecObject>>, Augmentation<TspecObject>> augmentation = Collections.emptyMap();

    public TspecObjectBuilder() {
    }

    public TspecObjectBuilder(TspecObject base) {
        AugmentationHolder casted;
        this._maximumPacketSize = base.getMaximumPacketSize();
        this._minimumPolicedUnit = base.getMinimumPolicedUnit();
        this._peakDataRate = base.getPeakDataRate();
        this._tokenBucketRate = base.getTokenBucketRate();
        this._tokenBucketSize = base.getTokenBucketSize();
        if (base instanceof TspecObjectImpl) {
            TspecObjectImpl impl = (TspecObjectImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<TspecObject>>, Augmentation<TspecObject>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public Long getMaximumPacketSize() {
        return this._maximumPacketSize;
    }

    public Long getMinimumPolicedUnit() {
        return this._minimumPolicedUnit;
    }

    public Float32 getPeakDataRate() {
        return this._peakDataRate;
    }

    public Float32 getTokenBucketRate() {
        return this._tokenBucketRate;
    }

    public Float32 getTokenBucketSize() {
        return this._tokenBucketSize;
    }

    public <E extends Augmentation<TspecObject>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkMaximumPacketSizeRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", (Object)value);
    }

    public TspecObjectBuilder setMaximumPacketSize(Long value) {
        if (value != null) {
            TspecObjectBuilder.checkMaximumPacketSizeRange(value);
        }
        this._maximumPacketSize = value;
        return this;
    }

    private static void checkMinimumPolicedUnitRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", (Object)value);
    }

    public TspecObjectBuilder setMinimumPolicedUnit(Long value) {
        if (value != null) {
            TspecObjectBuilder.checkMinimumPolicedUnitRange(value);
        }
        this._minimumPolicedUnit = value;
        return this;
    }

    public TspecObjectBuilder setPeakDataRate(Float32 value) {
        this._peakDataRate = value;
        return this;
    }

    public TspecObjectBuilder setTokenBucketRate(Float32 value) {
        this._tokenBucketRate = value;
        return this;
    }

    public TspecObjectBuilder setTokenBucketSize(Float32 value) {
        this._tokenBucketSize = value;
        return this;
    }

    public TspecObjectBuilder addAugmentation(Class<? extends Augmentation<TspecObject>> augmentationType, Augmentation<TspecObject> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<TspecObject>>, Augmentation<TspecObject>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public TspecObjectBuilder removeAugmentation(Class<? extends Augmentation<TspecObject>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public TspecObject build() {
        return new TspecObjectImpl(this);
    }

    private static final class TspecObjectImpl
    implements TspecObject {
        private final Long _maximumPacketSize;
        private final Long _minimumPolicedUnit;
        private final Float32 _peakDataRate;
        private final Float32 _tokenBucketRate;
        private final Float32 _tokenBucketSize;
        private Map<Class<? extends Augmentation<TspecObject>>, Augmentation<TspecObject>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        private TspecObjectImpl(TspecObjectBuilder base) {
            this._maximumPacketSize = base.getMaximumPacketSize();
            this._minimumPolicedUnit = base.getMinimumPolicedUnit();
            this._peakDataRate = base.getPeakDataRate();
            this._tokenBucketRate = base.getTokenBucketRate();
            this._tokenBucketSize = base.getTokenBucketSize();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<TspecObject> getImplementedInterface() {
            return TspecObject.class;
        }

        @Override
        public Long getMaximumPacketSize() {
            return this._maximumPacketSize;
        }

        @Override
        public Long getMinimumPolicedUnit() {
            return this._minimumPolicedUnit;
        }

        @Override
        public Float32 getPeakDataRate() {
            return this._peakDataRate;
        }

        @Override
        public Float32 getTokenBucketRate() {
            return this._tokenBucketRate;
        }

        @Override
        public Float32 getTokenBucketSize() {
            return this._tokenBucketSize;
        }

        @Override
        public <E extends Augmentation<TspecObject>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._maximumPacketSize);
            result = 31 * result + Objects.hashCode(this._minimumPolicedUnit);
            result = 31 * result + Objects.hashCode(this._peakDataRate);
            result = 31 * result + Objects.hashCode(this._tokenBucketRate);
            result = 31 * result + Objects.hashCode(this._tokenBucketSize);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!TspecObject.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            TspecObject other = (TspecObject)obj;
            if (!Objects.equals(this._maximumPacketSize, other.getMaximumPacketSize())) {
                return false;
            }
            if (!Objects.equals(this._minimumPolicedUnit, other.getMinimumPolicedUnit())) {
                return false;
            }
            if (!Objects.equals(this._peakDataRate, other.getPeakDataRate())) {
                return false;
            }
            if (!Objects.equals(this._tokenBucketRate, other.getTokenBucketRate())) {
                return false;
            }
            if (!Objects.equals(this._tokenBucketSize, other.getTokenBucketSize())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                TspecObjectImpl otherImpl = (TspecObjectImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<TspecObject>>, Augmentation<TspecObject>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("TspecObject");
            CodeHelpers.appendValue(helper, "_maximumPacketSize", this._maximumPacketSize);
            CodeHelpers.appendValue(helper, "_minimumPolicedUnit", this._minimumPolicedUnit);
            CodeHelpers.appendValue(helper, "_peakDataRate", this._peakDataRate);
            CodeHelpers.appendValue(helper, "_tokenBucketRate", this._tokenBucketRate);
            CodeHelpers.appendValue(helper, "_tokenBucketSize", this._tokenBucketSize);
            CodeHelpers.appendValue(helper, "augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

