/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev171025;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.opendaylight.yangtools.yang.binding.Enumeration;

public enum FailureType implements Enumeration
{
    Unsent(0, "unsent"),
    NoAck(1, "no-ack"),
    Failed(2, "failed");

    private static final Map<String, FailureType> NAME_MAP;
    private static final Map<Integer, FailureType> VALUE_MAP;
    private final String name;
    private final int value;

    private FailureType(int value, String name) {
        this.value = value;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int getIntValue() {
        return this.value;
    }

    public static Optional<FailureType> forName(String name) {
        return Optional.ofNullable(NAME_MAP.get(Objects.requireNonNull(name)));
    }

    public static FailureType forValue(int intValue) {
        return VALUE_MAP.get(intValue);
    }

    static {
        ImmutableMap.Builder<String, FailureType> nb = ImmutableMap.builder();
        ImmutableMap.Builder<Integer, FailureType> vb = ImmutableMap.builder();
        for (FailureType enumItem : FailureType.values()) {
            vb.put(enumItem.value, enumItem);
            nb.put(enumItem.name, enumItem);
        }
        NAME_MAP = nb.build();
        VALUE_MAP = vb.build();
    }
}

