/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev171025.pcep.client.attributes;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev171025.PccSyncState;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev171025.pcep.client.attributes.PathComputationClient;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev171025.pcep.client.attributes.path.computation.client.ReportedLsp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev171025.pcep.client.attributes.path.computation.client.StatefulTlv;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PathComputationClientBuilder
implements Builder<PathComputationClient> {
    private IpAddress _ipAddress;
    private List<ReportedLsp> _reportedLsp;
    private PccSyncState _stateSync;
    private StatefulTlv _statefulTlv;
    Map<Class<? extends Augmentation<PathComputationClient>>, Augmentation<PathComputationClient>> augmentation = Collections.emptyMap();

    public PathComputationClientBuilder() {
    }

    public PathComputationClientBuilder(PathComputationClient base) {
        AugmentationHolder casted;
        this._ipAddress = base.getIpAddress();
        this._reportedLsp = base.getReportedLsp();
        this._stateSync = base.getStateSync();
        this._statefulTlv = base.getStatefulTlv();
        if (base instanceof PathComputationClientImpl) {
            PathComputationClientImpl impl = (PathComputationClientImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PathComputationClient>>, Augmentation<PathComputationClient>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public IpAddress getIpAddress() {
        return this._ipAddress;
    }

    public List<ReportedLsp> getReportedLsp() {
        return this._reportedLsp;
    }

    public PccSyncState getStateSync() {
        return this._stateSync;
    }

    public StatefulTlv getStatefulTlv() {
        return this._statefulTlv;
    }

    public <E extends Augmentation<PathComputationClient>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public PathComputationClientBuilder setIpAddress(IpAddress value) {
        this._ipAddress = value;
        return this;
    }

    public PathComputationClientBuilder setReportedLsp(List<ReportedLsp> values) {
        this._reportedLsp = values;
        return this;
    }

    public PathComputationClientBuilder setStateSync(PccSyncState value) {
        this._stateSync = value;
        return this;
    }

    public PathComputationClientBuilder setStatefulTlv(StatefulTlv value) {
        this._statefulTlv = value;
        return this;
    }

    public PathComputationClientBuilder addAugmentation(Class<? extends Augmentation<PathComputationClient>> augmentationType, Augmentation<PathComputationClient> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PathComputationClient>>, Augmentation<PathComputationClient>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PathComputationClientBuilder removeAugmentation(Class<? extends Augmentation<PathComputationClient>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public PathComputationClient build() {
        return new PathComputationClientImpl(this);
    }

    private static final class PathComputationClientImpl
    implements PathComputationClient {
        private final IpAddress _ipAddress;
        private final List<ReportedLsp> _reportedLsp;
        private final PccSyncState _stateSync;
        private final StatefulTlv _statefulTlv;
        private Map<Class<? extends Augmentation<PathComputationClient>>, Augmentation<PathComputationClient>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        private PathComputationClientImpl(PathComputationClientBuilder base) {
            this._ipAddress = base.getIpAddress();
            this._reportedLsp = base.getReportedLsp();
            this._stateSync = base.getStateSync();
            this._statefulTlv = base.getStatefulTlv();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<PathComputationClient> getImplementedInterface() {
            return PathComputationClient.class;
        }

        @Override
        public IpAddress getIpAddress() {
            return this._ipAddress;
        }

        @Override
        public List<ReportedLsp> getReportedLsp() {
            return this._reportedLsp;
        }

        @Override
        public PccSyncState getStateSync() {
            return this._stateSync;
        }

        @Override
        public StatefulTlv getStatefulTlv() {
            return this._statefulTlv;
        }

        @Override
        public <E extends Augmentation<PathComputationClient>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ipAddress);
            result = 31 * result + Objects.hashCode(this._reportedLsp);
            result = 31 * result + Objects.hashCode(this._stateSync);
            result = 31 * result + Objects.hashCode(this._statefulTlv);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PathComputationClient.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PathComputationClient other = (PathComputationClient)obj;
            if (!Objects.equals(this._ipAddress, other.getIpAddress())) {
                return false;
            }
            if (!Objects.equals(this._reportedLsp, other.getReportedLsp())) {
                return false;
            }
            if (!Objects.equals(this._stateSync, other.getStateSync())) {
                return false;
            }
            if (!Objects.equals(this._statefulTlv, other.getStatefulTlv())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PathComputationClientImpl otherImpl = (PathComputationClientImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PathComputationClient>>, Augmentation<PathComputationClient>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("PathComputationClient");
            CodeHelpers.appendValue(helper, "_ipAddress", this._ipAddress);
            CodeHelpers.appendValue(helper, "_reportedLsp", this._reportedLsp);
            CodeHelpers.appendValue(helper, "_stateSync", this._stateSync);
            CodeHelpers.appendValue(helper, "_statefulTlv", this._statefulTlv);
            CodeHelpers.appendValue(helper, "augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

