/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev171025.pcep.client.attributes.path.computation.client;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev171025.LspMetadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev171025.lsp.metadata.Metadata;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev171025.pcep.client.attributes.path.computation.client.ReportedLsp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev171025.pcep.client.attributes.path.computation.client.ReportedLspKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev171025.pcep.client.attributes.path.computation.client.reported.lsp.Path;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ReportedLspBuilder
implements Builder<ReportedLsp> {
    private Metadata _metadata;
    private String _name;
    private List<Path> _path;
    private ReportedLspKey key;
    Map<Class<? extends Augmentation<ReportedLsp>>, Augmentation<ReportedLsp>> augmentation = Collections.emptyMap();

    public ReportedLspBuilder() {
    }

    public ReportedLspBuilder(LspMetadata arg) {
        this._metadata = arg.getMetadata();
    }

    public ReportedLspBuilder(ReportedLsp base) {
        AugmentationHolder casted;
        if (base.key() == null) {
            this.key = new ReportedLspKey(base.getName());
            this._name = base.getName();
        } else {
            this.key = base.key();
            this._name = this.key.getName();
        }
        this._metadata = base.getMetadata();
        this._path = base.getPath();
        if (base instanceof ReportedLspImpl) {
            ReportedLspImpl impl = (ReportedLspImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ReportedLsp>>, Augmentation<ReportedLsp>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof LspMetadata) {
            this._metadata = ((LspMetadata)arg).getMetadata();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.rev171025.LspMetadata]");
    }

    public ReportedLspKey key() {
        return this.key;
    }

    public Metadata getMetadata() {
        return this._metadata;
    }

    public String getName() {
        return this._name;
    }

    public List<Path> getPath() {
        return this._path;
    }

    public <E extends Augmentation<ReportedLsp>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public ReportedLspBuilder withKey(ReportedLspKey key) {
        this.key = key;
        return this;
    }

    public ReportedLspBuilder setMetadata(Metadata value) {
        this._metadata = value;
        return this;
    }

    public ReportedLspBuilder setName(String value) {
        this._name = value;
        return this;
    }

    public ReportedLspBuilder setPath(List<Path> values) {
        this._path = values;
        return this;
    }

    public ReportedLspBuilder addAugmentation(Class<? extends Augmentation<ReportedLsp>> augmentationType, Augmentation<ReportedLsp> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ReportedLsp>>, Augmentation<ReportedLsp>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ReportedLspBuilder removeAugmentation(Class<? extends Augmentation<ReportedLsp>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public ReportedLsp build() {
        return new ReportedLspImpl(this);
    }

    private static final class ReportedLspImpl
    implements ReportedLsp {
        private final Metadata _metadata;
        private final String _name;
        private final List<Path> _path;
        private final ReportedLspKey key;
        private Map<Class<? extends Augmentation<ReportedLsp>>, Augmentation<ReportedLsp>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        private ReportedLspImpl(ReportedLspBuilder base) {
            if (base.key() == null) {
                this.key = new ReportedLspKey(base.getName());
                this._name = base.getName();
            } else {
                this.key = base.key();
                this._name = this.key.getName();
            }
            this._metadata = base.getMetadata();
            this._path = base.getPath();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<ReportedLsp> getImplementedInterface() {
            return ReportedLsp.class;
        }

        @Override
        public ReportedLspKey key() {
            return this.key;
        }

        @Override
        public Metadata getMetadata() {
            return this._metadata;
        }

        @Override
        public String getName() {
            return this._name;
        }

        @Override
        public List<Path> getPath() {
            return this._path;
        }

        @Override
        public <E extends Augmentation<ReportedLsp>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._metadata);
            result = 31 * result + Objects.hashCode(this._name);
            result = 31 * result + Objects.hashCode(this._path);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ReportedLsp.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ReportedLsp other = (ReportedLsp)obj;
            if (!Objects.equals(this._metadata, other.getMetadata())) {
                return false;
            }
            if (!Objects.equals(this._name, other.getName())) {
                return false;
            }
            if (!Objects.equals(this._path, other.getPath())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ReportedLspImpl otherImpl = (ReportedLspImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ReportedLsp>>, Augmentation<ReportedLsp>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("ReportedLsp");
            CodeHelpers.appendValue(helper, "_metadata", this._metadata);
            CodeHelpers.appendValue(helper, "_name", this._name);
            CodeHelpers.appendValue(helper, "_path", this._path);
            CodeHelpers.appendValue(helper, "augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

