/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.p2p.rev130819.tunnel.p2p.path.cfg.attributes;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.p2p.rev130819.TunnelP2pPathHops;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.p2p.rev130819.tunnel.p2p.path.cfg.attributes.ExplicitHops;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.p2p.rev130819.tunnel.p2p.path.cfg.attributes.ExplicitHopsKey;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class ExplicitHopsBuilder
implements Builder<ExplicitHops> {
    private Long _order;
    private Boolean _loose;
    private ExplicitHopsKey key;
    Map<Class<? extends Augmentation<ExplicitHops>>, Augmentation<ExplicitHops>> augmentation = Collections.emptyMap();

    public ExplicitHopsBuilder() {
    }

    public ExplicitHopsBuilder(TunnelP2pPathHops arg) {
        this._order = arg.getOrder();
    }

    public ExplicitHopsBuilder(ExplicitHops base) {
        AugmentationHolder casted;
        if (base.key() == null) {
            this.key = new ExplicitHopsKey(base.getOrder());
            this._order = base.getOrder();
        } else {
            this.key = base.key();
            this._order = this.key.getOrder();
        }
        this._loose = base.isLoose();
        if (base instanceof ExplicitHopsImpl) {
            ExplicitHopsImpl impl = (ExplicitHopsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<ExplicitHops>>, Augmentation<ExplicitHops>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof TunnelP2pPathHops) {
            this._order = ((TunnelP2pPathHops)arg).getOrder();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.p2p.rev130819.TunnelP2pPathHops]");
    }

    public ExplicitHopsKey key() {
        return this.key;
    }

    public Long getOrder() {
        return this._order;
    }

    public Boolean isLoose() {
        return this._loose;
    }

    public <E extends Augmentation<ExplicitHops>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public ExplicitHopsBuilder withKey(ExplicitHopsKey key) {
        this.key = key;
        return this;
    }

    private static void checkOrderRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..4294967295]]", (Object)value);
    }

    public ExplicitHopsBuilder setOrder(Long value) {
        if (value != null) {
            ExplicitHopsBuilder.checkOrderRange(value);
        }
        this._order = value;
        return this;
    }

    public ExplicitHopsBuilder setLoose(Boolean value) {
        this._loose = value;
        return this;
    }

    public ExplicitHopsBuilder addAugmentation(Class<? extends Augmentation<ExplicitHops>> augmentationType, Augmentation<ExplicitHops> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<ExplicitHops>>, Augmentation<ExplicitHops>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public ExplicitHopsBuilder removeAugmentation(Class<? extends Augmentation<ExplicitHops>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public ExplicitHops build() {
        return new ExplicitHopsImpl(this);
    }

    private static final class ExplicitHopsImpl
    implements ExplicitHops {
        private final Long _order;
        private final Boolean _loose;
        private final ExplicitHopsKey key;
        private Map<Class<? extends Augmentation<ExplicitHops>>, Augmentation<ExplicitHops>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        private ExplicitHopsImpl(ExplicitHopsBuilder base) {
            if (base.key() == null) {
                this.key = new ExplicitHopsKey(base.getOrder());
                this._order = base.getOrder();
            } else {
                this.key = base.key();
                this._order = this.key.getOrder();
            }
            this._loose = base.isLoose();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<ExplicitHops> getImplementedInterface() {
            return ExplicitHops.class;
        }

        @Override
        public ExplicitHopsKey key() {
            return this.key;
        }

        @Override
        public Long getOrder() {
            return this._order;
        }

        @Override
        public Boolean isLoose() {
            return this._loose;
        }

        @Override
        public <E extends Augmentation<ExplicitHops>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._order);
            result = 31 * result + Objects.hashCode(this._loose);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!ExplicitHops.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            ExplicitHops other = (ExplicitHops)obj;
            if (!Objects.equals(this._order, other.getOrder())) {
                return false;
            }
            if (!Objects.equals(this._loose, other.isLoose())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                ExplicitHopsImpl otherImpl = (ExplicitHopsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<ExplicitHops>>, Augmentation<ExplicitHops>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("ExplicitHops");
            CodeHelpers.appendValue(helper, "_order", this._order);
            CodeHelpers.appendValue(helper, "_loose", this._loose);
            CodeHelpers.appendValue(helper, "augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

