/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev131005.ClassType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilter;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.Link1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepLinkCfgAttributes;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class Link1Builder
implements Builder<Link1> {
    private Bandwidth _bandwidth;
    private ClassType _classType;
    private AttributeFilter _excludeAny;
    private Short _holdPriority;
    private AttributeFilter _includeAll;
    private AttributeFilter _includeAny;
    private String _sessionName;
    private Short _setupPriority;
    private String _symbolicPathName;
    private Boolean _labelRecordingDesired;
    private Boolean _localProtectionDesired;
    private Boolean _seStyleDesired;

    public Link1Builder() {
    }

    public Link1Builder(TunnelPcepLinkCfgAttributes arg) {
        this._symbolicPathName = arg.getSymbolicPathName();
        this._classType = arg.getClassType();
        this._bandwidth = arg.getBandwidth();
        this._localProtectionDesired = arg.isLocalProtectionDesired();
        this._labelRecordingDesired = arg.isLabelRecordingDesired();
        this._seStyleDesired = arg.isSeStyleDesired();
        this._sessionName = arg.getSessionName();
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }

    public Link1Builder(TunnelAttributes arg) {
        this._localProtectionDesired = arg.isLocalProtectionDesired();
        this._labelRecordingDesired = arg.isLabelRecordingDesired();
        this._seStyleDesired = arg.isSeStyleDesired();
        this._sessionName = arg.getSessionName();
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }

    public Link1Builder(Priority arg) {
        this._holdPriority = arg.getHoldPriority();
        this._setupPriority = arg.getSetupPriority();
    }

    public Link1Builder(AttributeFilters arg) {
        this._includeAny = arg.getIncludeAny();
        this._excludeAny = arg.getExcludeAny();
        this._includeAll = arg.getIncludeAll();
    }

    public Link1Builder(Link1 base) {
        this._bandwidth = base.getBandwidth();
        this._classType = base.getClassType();
        this._excludeAny = base.getExcludeAny();
        this._holdPriority = base.getHoldPriority();
        this._includeAll = base.getIncludeAll();
        this._includeAny = base.getIncludeAny();
        this._sessionName = base.getSessionName();
        this._setupPriority = base.getSetupPriority();
        this._symbolicPathName = base.getSymbolicPathName();
        this._labelRecordingDesired = base.isLabelRecordingDesired();
        this._localProtectionDesired = base.isLocalProtectionDesired();
        this._seStyleDesired = base.isSeStyleDesired();
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof TunnelPcepLinkCfgAttributes) {
            this._symbolicPathName = ((TunnelPcepLinkCfgAttributes)arg).getSymbolicPathName();
            this._classType = ((TunnelPcepLinkCfgAttributes)arg).getClassType();
            this._bandwidth = ((TunnelPcepLinkCfgAttributes)arg).getBandwidth();
            isValidArg = true;
        }
        if (arg instanceof Priority) {
            this._holdPriority = ((Priority)arg).getHoldPriority();
            this._setupPriority = ((Priority)arg).getSetupPriority();
            isValidArg = true;
        }
        if (arg instanceof AttributeFilters) {
            this._includeAny = ((AttributeFilters)arg).getIncludeAny();
            this._excludeAny = ((AttributeFilters)arg).getExcludeAny();
            this._includeAll = ((AttributeFilters)arg).getIncludeAll();
            isValidArg = true;
        }
        if (arg instanceof TunnelAttributes) {
            this._localProtectionDesired = ((TunnelAttributes)arg).isLocalProtectionDesired();
            this._labelRecordingDesired = ((TunnelAttributes)arg).isLabelRecordingDesired();
            this._seStyleDesired = ((TunnelAttributes)arg).isSeStyleDesired();
            this._sessionName = ((TunnelAttributes)arg).getSessionName();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.TunnelPcepLinkCfgAttributes, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.Priority, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilters, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.TunnelAttributes]");
    }

    public Bandwidth getBandwidth() {
        return this._bandwidth;
    }

    public ClassType getClassType() {
        return this._classType;
    }

    public AttributeFilter getExcludeAny() {
        return this._excludeAny;
    }

    public Short getHoldPriority() {
        return this._holdPriority;
    }

    public AttributeFilter getIncludeAll() {
        return this._includeAll;
    }

    public AttributeFilter getIncludeAny() {
        return this._includeAny;
    }

    public String getSessionName() {
        return this._sessionName;
    }

    public Short getSetupPriority() {
        return this._setupPriority;
    }

    public String getSymbolicPathName() {
        return this._symbolicPathName;
    }

    public Boolean isLabelRecordingDesired() {
        return this._labelRecordingDesired;
    }

    public Boolean isLocalProtectionDesired() {
        return this._localProtectionDesired;
    }

    public Boolean isSeStyleDesired() {
        return this._seStyleDesired;
    }

    public Link1Builder setBandwidth(Bandwidth value) {
        this._bandwidth = value;
        return this;
    }

    public Link1Builder setClassType(ClassType value) {
        this._classType = value;
        return this;
    }

    public Link1Builder setExcludeAny(AttributeFilter value) {
        this._excludeAny = value;
        return this;
    }

    private static void checkHoldPriorityRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..255]]", (Object)value);
    }

    public Link1Builder setHoldPriority(Short value) {
        if (value != null) {
            Link1Builder.checkHoldPriorityRange(value);
        }
        this._holdPriority = value;
        return this;
    }

    public Link1Builder setIncludeAll(AttributeFilter value) {
        this._includeAll = value;
        return this;
    }

    public Link1Builder setIncludeAny(AttributeFilter value) {
        this._includeAny = value;
        return this;
    }

    public Link1Builder setSessionName(String value) {
        this._sessionName = value;
        return this;
    }

    private static void checkSetupPriorityRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..255]]", (Object)value);
    }

    public Link1Builder setSetupPriority(Short value) {
        if (value != null) {
            Link1Builder.checkSetupPriorityRange(value);
        }
        this._setupPriority = value;
        return this;
    }

    public Link1Builder setSymbolicPathName(String value) {
        this._symbolicPathName = value;
        return this;
    }

    public Link1Builder setLabelRecordingDesired(Boolean value) {
        this._labelRecordingDesired = value;
        return this;
    }

    public Link1Builder setLocalProtectionDesired(Boolean value) {
        this._localProtectionDesired = value;
        return this;
    }

    public Link1Builder setSeStyleDesired(Boolean value) {
        this._seStyleDesired = value;
        return this;
    }

    @Override
    public Link1 build() {
        return new Link1Impl(this);
    }

    private static final class Link1Impl
    implements Link1 {
        private final Bandwidth _bandwidth;
        private final ClassType _classType;
        private final AttributeFilter _excludeAny;
        private final Short _holdPriority;
        private final AttributeFilter _includeAll;
        private final AttributeFilter _includeAny;
        private final String _sessionName;
        private final Short _setupPriority;
        private final String _symbolicPathName;
        private final Boolean _labelRecordingDesired;
        private final Boolean _localProtectionDesired;
        private final Boolean _seStyleDesired;
        private int hash = 0;
        private volatile boolean hashValid = false;

        private Link1Impl(Link1Builder base) {
            this._bandwidth = base.getBandwidth();
            this._classType = base.getClassType();
            this._excludeAny = base.getExcludeAny();
            this._holdPriority = base.getHoldPriority();
            this._includeAll = base.getIncludeAll();
            this._includeAny = base.getIncludeAny();
            this._sessionName = base.getSessionName();
            this._setupPriority = base.getSetupPriority();
            this._symbolicPathName = base.getSymbolicPathName();
            this._labelRecordingDesired = base.isLabelRecordingDesired();
            this._localProtectionDesired = base.isLocalProtectionDesired();
            this._seStyleDesired = base.isSeStyleDesired();
        }

        public Class<Link1> getImplementedInterface() {
            return Link1.class;
        }

        @Override
        public Bandwidth getBandwidth() {
            return this._bandwidth;
        }

        @Override
        public ClassType getClassType() {
            return this._classType;
        }

        @Override
        public AttributeFilter getExcludeAny() {
            return this._excludeAny;
        }

        @Override
        public Short getHoldPriority() {
            return this._holdPriority;
        }

        @Override
        public AttributeFilter getIncludeAll() {
            return this._includeAll;
        }

        @Override
        public AttributeFilter getIncludeAny() {
            return this._includeAny;
        }

        @Override
        public String getSessionName() {
            return this._sessionName;
        }

        @Override
        public Short getSetupPriority() {
            return this._setupPriority;
        }

        @Override
        public String getSymbolicPathName() {
            return this._symbolicPathName;
        }

        @Override
        public Boolean isLabelRecordingDesired() {
            return this._labelRecordingDesired;
        }

        @Override
        public Boolean isLocalProtectionDesired() {
            return this._localProtectionDesired;
        }

        @Override
        public Boolean isSeStyleDesired() {
            return this._seStyleDesired;
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._bandwidth);
            result = 31 * result + Objects.hashCode(this._classType);
            result = 31 * result + Objects.hashCode(this._excludeAny);
            result = 31 * result + Objects.hashCode(this._holdPriority);
            result = 31 * result + Objects.hashCode(this._includeAll);
            result = 31 * result + Objects.hashCode(this._includeAny);
            result = 31 * result + Objects.hashCode(this._sessionName);
            result = 31 * result + Objects.hashCode(this._setupPriority);
            result = 31 * result + Objects.hashCode(this._symbolicPathName);
            result = 31 * result + Objects.hashCode(this._labelRecordingDesired);
            result = 31 * result + Objects.hashCode(this._localProtectionDesired);
            this.hash = result = 31 * result + Objects.hashCode(this._seStyleDesired);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Link1.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Link1 other = (Link1)obj;
            if (!Objects.equals(this._bandwidth, other.getBandwidth())) {
                return false;
            }
            if (!Objects.equals(this._classType, other.getClassType())) {
                return false;
            }
            if (!Objects.equals(this._excludeAny, other.getExcludeAny())) {
                return false;
            }
            if (!Objects.equals(this._holdPriority, other.getHoldPriority())) {
                return false;
            }
            if (!Objects.equals(this._includeAll, other.getIncludeAll())) {
                return false;
            }
            if (!Objects.equals(this._includeAny, other.getIncludeAny())) {
                return false;
            }
            if (!Objects.equals(this._sessionName, other.getSessionName())) {
                return false;
            }
            if (!Objects.equals(this._setupPriority, other.getSetupPriority())) {
                return false;
            }
            if (!Objects.equals(this._symbolicPathName, other.getSymbolicPathName())) {
                return false;
            }
            if (!Objects.equals(this._labelRecordingDesired, other.isLabelRecordingDesired())) {
                return false;
            }
            if (!Objects.equals(this._localProtectionDesired, other.isLocalProtectionDesired())) {
                return false;
            }
            return Objects.equals(this._seStyleDesired, other.isSeStyleDesired());
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("Link1");
            CodeHelpers.appendValue(helper, "_bandwidth", this._bandwidth);
            CodeHelpers.appendValue(helper, "_classType", this._classType);
            CodeHelpers.appendValue(helper, "_excludeAny", this._excludeAny);
            CodeHelpers.appendValue(helper, "_holdPriority", this._holdPriority);
            CodeHelpers.appendValue(helper, "_includeAll", this._includeAll);
            CodeHelpers.appendValue(helper, "_includeAny", this._includeAny);
            CodeHelpers.appendValue(helper, "_sessionName", this._sessionName);
            CodeHelpers.appendValue(helper, "_setupPriority", this._setupPriority);
            CodeHelpers.appendValue(helper, "_symbolicPathName", this._symbolicPathName);
            CodeHelpers.appendValue(helper, "_labelRecordingDesired", this._labelRecordingDesired);
            CodeHelpers.appendValue(helper, "_localProtectionDesired", this._localProtectionDesired);
            CodeHelpers.appendValue(helper, "_seStyleDesired", this._seStyleDesired);
            return helper.toString();
        }
    }
}

