/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.tunnel.pcep.supporting.node.attributes;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.tunnel.pcep.rev130820.tunnel.pcep.supporting.node.attributes.PathComputationClient;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class PathComputationClientBuilder
implements Builder<PathComputationClient> {
    private Boolean _controlling;
    Map<Class<? extends Augmentation<PathComputationClient>>, Augmentation<PathComputationClient>> augmentation = Collections.emptyMap();

    public PathComputationClientBuilder() {
    }

    public PathComputationClientBuilder(PathComputationClient base) {
        AugmentationHolder casted;
        this._controlling = base.isControlling();
        if (base instanceof PathComputationClientImpl) {
            PathComputationClientImpl impl = (PathComputationClientImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<PathComputationClient>>, Augmentation<PathComputationClient>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)((Object)base)).augmentations().isEmpty()) {
            this.augmentation = new HashMap(casted.augmentations());
        }
    }

    public Boolean isControlling() {
        return this._controlling;
    }

    public <E extends Augmentation<PathComputationClient>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    public PathComputationClientBuilder setControlling(Boolean value) {
        this._controlling = value;
        return this;
    }

    public PathComputationClientBuilder addAugmentation(Class<? extends Augmentation<PathComputationClient>> augmentationType, Augmentation<PathComputationClient> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<PathComputationClient>>, Augmentation<PathComputationClient>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public PathComputationClientBuilder removeAugmentation(Class<? extends Augmentation<PathComputationClient>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public PathComputationClient build() {
        return new PathComputationClientImpl(this);
    }

    private static final class PathComputationClientImpl
    implements PathComputationClient {
        private final Boolean _controlling;
        private Map<Class<? extends Augmentation<PathComputationClient>>, Augmentation<PathComputationClient>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        private PathComputationClientImpl(PathComputationClientBuilder base) {
            this._controlling = base.isControlling();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<PathComputationClient> getImplementedInterface() {
            return PathComputationClient.class;
        }

        @Override
        public Boolean isControlling() {
            return this._controlling;
        }

        @Override
        public <E extends Augmentation<PathComputationClient>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._controlling);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!PathComputationClient.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            PathComputationClient other = (PathComputationClient)obj;
            if (!Objects.equals(this._controlling, other.isControlling())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                PathComputationClientImpl otherImpl = (PathComputationClientImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<PathComputationClient>>, Augmentation<PathComputationClient>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals(other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("PathComputationClient");
            CodeHelpers.appendValue(helper, "_controlling", this._controlling);
            CodeHelpers.appendValue(helper, "augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

